//-----------------------------------------------------------------------------
//  File: RTC6expl.h                            Copyright (c) 2025 SCANLAB GmbH
//-----------------------------------------------------------------------------
//
//
//
//  Abstract
//      RTC6 function prototypes for explicitly linking - also known as
//      dynamic load linking - to the RTC6DLL.DLL or libslrtc6.so.
//
//      This file was automatically generated on 2025-10-24
//
//-----------------------------------------------------------------------------

#pragma once

#if defined(__cplusplus)
extern "C" {
#endif //defined(__cplusplus)

#ifdef _WIN32
    #include <windows.h>
    #if !defined(ULONG_PTR)         //  usually defined in <BaseTsd.h>
        #if !defined(_WIN64)
            #define ULONG_PTR UINT
        #else
            #define ULONG_PTR UINT64
        #endif // !defined(_WIN64)
    #endif // !defined(ULONG_PTR)
#else
    #include <stdint.h>
    typedef int32_t LONG;     //  LONG  is assumed to be 4 Bytes
    typedef uint32_t UINT;     //  UINT  is assumed to be 4 Bytes
    typedef uint64_t UINT64;
    typedef uintptr_t ULONG_PTR;
    #define __stdcall
#endif

#include <stdbool.h>

//------------------------ DLL Handling ---------------------------------------
long RTC6open(void);
void RTC6close(void);
//-----------------------------------------------------------------------------

typedef UINT (__stdcall *INIT_RTC6_DLL_FP)(void);
extern INIT_RTC6_DLL_FP init_rtc6_dll;
typedef void (__stdcall *FREE_RTC6_DLL_FP)(void);
extern FREE_RTC6_DLL_FP free_rtc6_dll;
typedef void (__stdcall *SET_RTC4_MODE_FP)(void);
extern SET_RTC4_MODE_FP set_rtc4_mode;
typedef void (__stdcall *SET_RTC5_MODE_FP)(void);
extern SET_RTC5_MODE_FP set_rtc5_mode;
typedef void (__stdcall *SET_RTC6_MODE_FP)(void);
extern SET_RTC6_MODE_FP set_rtc6_mode;
typedef UINT (__stdcall *GET_RTC_MODE_FP)(void);
extern GET_RTC_MODE_FP get_rtc_mode;
typedef UINT (__stdcall *N_GET_ERROR_FP)(const UINT CardNo);
extern N_GET_ERROR_FP n_get_error;
typedef UINT (__stdcall *N_GET_LAST_ERROR_FP)(const UINT CardNo);
extern N_GET_LAST_ERROR_FP n_get_last_error;
typedef void (__stdcall *N_RESET_ERROR_FP)(const UINT CardNo, const UINT Code);
extern N_RESET_ERROR_FP n_reset_error;
typedef UINT (__stdcall *N_SET_VERIFY_FP)(const UINT CardNo, const UINT Verify);
extern N_SET_VERIFY_FP n_set_verify;
typedef UINT (__stdcall *GET_ERROR_FP)(void);
extern GET_ERROR_FP get_error;
typedef UINT (__stdcall *GET_LAST_ERROR_FP)(void);
extern GET_LAST_ERROR_FP get_last_error;
typedef void (__stdcall *RESET_ERROR_FP)(const UINT Code);
extern RESET_ERROR_FP reset_error;
typedef UINT (__stdcall *SET_VERIFY_FP)(const UINT Verify);
extern SET_VERIFY_FP set_verify;
typedef UINT (__stdcall *VERIFY_CHECKSUM_FP)(const char* Name);
extern VERIFY_CHECKSUM_FP verify_checksum;
typedef UINT (__stdcall *ETH_COUNT_CARDS_FP)(void);
extern ETH_COUNT_CARDS_FP eth_count_cards;
typedef UINT (__stdcall *ETH_FOUND_CARDS_FP)(void);
extern ETH_FOUND_CARDS_FP eth_found_cards;
typedef UINT (__stdcall *ETH_MAX_CARD_FP)(void);
extern ETH_MAX_CARD_FP eth_max_card;
typedef LONG (__stdcall *ETH_REMOVE_CARD_FP)(const UINT CardNo);
extern ETH_REMOVE_CARD_FP eth_remove_card;
typedef void (__stdcall *ETH_GET_CARD_INFO_FP)(const UINT CardNo, const ULONG_PTR Ptr);
extern ETH_GET_CARD_INFO_FP eth_get_card_info;
typedef void (__stdcall *ETH_GET_CARD_INFO_SEARCH_FP)(const UINT SearchNo, const ULONG_PTR Ptr);
extern ETH_GET_CARD_INFO_SEARCH_FP eth_get_card_info_search;
typedef void (__stdcall *ETH_SET_SEARCH_CARDS_TIMEOUT_FP)(const UINT TimeOut);
extern ETH_SET_SEARCH_CARDS_TIMEOUT_FP eth_set_search_cards_timeout;
typedef UINT (__stdcall *ETH_SEARCH_CARDS_FP)(const UINT Ip, const UINT NetMask);
extern ETH_SEARCH_CARDS_FP eth_search_cards;
typedef UINT (__stdcall *ETH_SEARCH_CARDS_RANGE_FP)(const UINT StartIp, const UINT EndIp);
extern ETH_SEARCH_CARDS_RANGE_FP eth_search_cards_range;
typedef LONG (__stdcall *ETH_ASSIGN_CARD_IP_FP)(const UINT Ip, const UINT CardNo);
extern ETH_ASSIGN_CARD_IP_FP eth_assign_card_ip;
typedef LONG (__stdcall *ETH_ASSIGN_CARD_FP)(const UINT SearchNo, const UINT CardNo);
extern ETH_ASSIGN_CARD_FP eth_assign_card;
typedef UINT (__stdcall *ETH_CONVERT_STRING_TO_IP_FP)(const char* IpString);
extern ETH_CONVERT_STRING_TO_IP_FP eth_convert_string_to_ip;
typedef void (__stdcall *ETH_CONVERT_IP_TO_STRING_FP)(const UINT Ip, const ULONG_PTR IpString);
extern ETH_CONVERT_IP_TO_STRING_FP eth_convert_ip_to_string;
typedef UINT (__stdcall *ETH_GET_IP_FP)(const UINT CardNo);
extern ETH_GET_IP_FP eth_get_ip;
typedef UINT (__stdcall *ETH_GET_IP_SEARCH_FP)(const UINT SearchNo);
extern ETH_GET_IP_SEARCH_FP eth_get_ip_search;
typedef UINT (__stdcall *ETH_GET_SERIAL_SEARCH_FP)(const UINT SearchNo);
extern ETH_GET_SERIAL_SEARCH_FP eth_get_serial_search;
typedef UINT (__stdcall *ETH_FULL_RESET_FP)(const UINT CardNo);
extern ETH_FULL_RESET_FP eth_full_reset;
typedef UINT (__stdcall *N_ETH_GET_LAST_ERROR_FP)(const UINT CardNo);
extern N_ETH_GET_LAST_ERROR_FP n_eth_get_last_error;
typedef UINT (__stdcall *N_ETH_GET_ERROR_FP)(const UINT CardNo);
extern N_ETH_GET_ERROR_FP n_eth_get_error;
typedef UINT (__stdcall *N_ETH_ERROR_DUMP_FP)(const UINT CardNo, const ULONG_PTR Dump);
extern N_ETH_ERROR_DUMP_FP n_eth_error_dump;
typedef UINT (__stdcall *N_ETH_SET_STATIC_IP_FP)(const UINT CardNo, const UINT Ip, const UINT NetMask, const UINT Gateway);
extern N_ETH_SET_STATIC_IP_FP n_eth_set_static_ip;
typedef UINT (__stdcall *N_ETH_GET_STATIC_IP_FP)(const UINT CardNo, UINT* Ip, UINT* NetMask, UINT* Gateway);
extern N_ETH_GET_STATIC_IP_FP n_eth_get_static_ip;
typedef UINT (__stdcall *N_ETH_SET_PORT_NUMBERS_FP)(const UINT CardNo, const UINT UDPsearch, const UINT UDPexcl, const UINT TCP);
extern N_ETH_SET_PORT_NUMBERS_FP n_eth_set_port_numbers;
typedef UINT (__stdcall *N_ETH_GET_PORT_NUMBERS_FP)(const UINT CardNo, UINT* UDPsearch, UINT* UDPexcl, UINT* TCP);
extern N_ETH_GET_PORT_NUMBERS_FP n_eth_get_port_numbers;
typedef void (__stdcall *N_ETH_SET_COM_TIMEOUTS_FP)(const UINT CardNo, const UINT AcquireTimeout, const UINT AcquireMaxRetries, const UINT SendRecvTimeout, const UINT SendRecvMaxRetries, const UINT KeepAlive, const UINT KeepInterval);
extern N_ETH_SET_COM_TIMEOUTS_FP n_eth_set_com_timeouts;
typedef void (__stdcall *N_ETH_GET_COM_TIMEOUTS_FP)(const UINT CardNo, UINT* AcquireTimeout, UINT* AcquireMaxRetries, UINT* SendRecvTimeout, UINT* SendRecvMaxRetries, UINT* KeepAlive, UINT* KeepInterval);
extern N_ETH_GET_COM_TIMEOUTS_FP n_eth_get_com_timeouts;
typedef void (__stdcall *N_ETH_SET_COM_TIMEOUTS_AUTO_FP)(const UINT CardNo, const double InitialTimeout, const double MaxTimeout, const double Multiplier, const UINT Mode);
extern N_ETH_SET_COM_TIMEOUTS_AUTO_FP n_eth_set_com_timeouts_auto;
typedef void (__stdcall *N_ETH_GET_COM_TIMEOUTS_AUTO_FP)(const UINT CardNo, double* InitialTimeout, double* MaxTimeout, double* Multiplier, UINT* Mode);
extern N_ETH_GET_COM_TIMEOUTS_AUTO_FP n_eth_get_com_timeouts_auto;
typedef UINT (__stdcall *N_ETH_SET_HIGH_PERFORMANCE_MODE_FP)(const UINT CardNo, const UINT Mode);
extern N_ETH_SET_HIGH_PERFORMANCE_MODE_FP n_eth_set_high_performance_mode;
typedef UINT (__stdcall *N_ETH_CHECK_CONNECTION_FP)(const UINT CardNo);
extern N_ETH_CHECK_CONNECTION_FP n_eth_check_connection;
typedef void (__stdcall *N_SET_ETH_BOOT_CONTROL_FP)(const UINT CardNo, const UINT Ctrl);
extern N_SET_ETH_BOOT_CONTROL_FP n_set_eth_boot_control;
typedef void (__stdcall *N_ETH_BOOT_TIMEOUT_FP)(const UINT CardNo, const UINT Timeout);
extern N_ETH_BOOT_TIMEOUT_FP n_eth_boot_timeout;
typedef void (__stdcall *N_ETH_SET_REMOTE_TGM_FORMAT_FP)(const UINT CardNo, const UINT Format);
extern N_ETH_SET_REMOTE_TGM_FORMAT_FP n_eth_set_remote_tgm_format;
typedef void (__stdcall *N_ETH_BOOT_DCMD_FP)(const UINT CardNo);
extern N_ETH_BOOT_DCMD_FP n_eth_boot_dcmd;
typedef UINT (__stdcall *N_STORE_PROGRAM_FP)(const UINT CardNo, const UINT Mode);
extern N_STORE_PROGRAM_FP n_store_program;
typedef UINT (__stdcall *N_READ_IMAGE_ETH_FP)(const UINT CardNo, const char* Name);
extern N_READ_IMAGE_ETH_FP n_read_image_eth;
typedef UINT (__stdcall *N_WRITE_IMAGE_ETH_FP)(const UINT CardNo, const char* Name);
extern N_WRITE_IMAGE_ETH_FP n_write_image_eth;
typedef void (__stdcall *N_ETH_CONFIGURE_LINK_LOSS_FP)(const UINT CardNo, const UINT Mode);
extern N_ETH_CONFIGURE_LINK_LOSS_FP n_eth_configure_link_loss;
typedef void (__stdcall *N_ETH_GET_STANDALONE_STATUS_FP)(const UINT CardNo, UINT* Status, UINT* Error, UINT* Mode);
extern N_ETH_GET_STANDALONE_STATUS_FP n_eth_get_standalone_status;
typedef void (__stdcall *N_ETH_CONFIG_WAVEFORM_STREAMING_CTRL_FP)(const UINT CardNo, const UINT Size, const UINT Flags);
extern N_ETH_CONFIG_WAVEFORM_STREAMING_CTRL_FP n_eth_config_waveform_streaming_ctrl;
typedef UINT (__stdcall *ETH_GET_LAST_ERROR_FP)(void);
extern ETH_GET_LAST_ERROR_FP eth_get_last_error;
typedef UINT (__stdcall *ETH_GET_ERROR_FP)(void);
extern ETH_GET_ERROR_FP eth_get_error;
typedef UINT (__stdcall *ETH_ERROR_DUMP_FP)(const ULONG_PTR Dump);
extern ETH_ERROR_DUMP_FP eth_error_dump;
typedef UINT (__stdcall *ETH_SET_STATIC_IP_FP)(const UINT Ip, const UINT NetMask, const UINT Gateway);
extern ETH_SET_STATIC_IP_FP eth_set_static_ip;
typedef UINT (__stdcall *ETH_GET_STATIC_IP_FP)(UINT* Ip, UINT* NetMask, UINT* Gateway);
extern ETH_GET_STATIC_IP_FP eth_get_static_ip;
typedef UINT (__stdcall *ETH_SET_PORT_NUMBERS_FP)(const UINT UDPsearch, const UINT UDPexcl, const UINT TCP);
extern ETH_SET_PORT_NUMBERS_FP eth_set_port_numbers;
typedef UINT (__stdcall *ETH_GET_PORT_NUMBERS_FP)(UINT* UDPsearch, UINT* UDPexcl, UINT* TCP);
extern ETH_GET_PORT_NUMBERS_FP eth_get_port_numbers;
typedef void (__stdcall *ETH_SET_COM_TIMEOUTS_FP)(const UINT AcquireTimeout, const UINT AcquireMaxRetries, const UINT SendRecvTimeout, const UINT SendRecvMaxRetries, const UINT KeepAlive, const UINT KeepInterval);
extern ETH_SET_COM_TIMEOUTS_FP eth_set_com_timeouts;
typedef void (__stdcall *ETH_GET_COM_TIMEOUTS_FP)(UINT* AcquireTimeout, UINT* AcquireMaxRetries, UINT* SendRecvTimeout, UINT* SendRecvMaxRetries, UINT* KeepAlive, UINT* KeepInterval);
extern ETH_GET_COM_TIMEOUTS_FP eth_get_com_timeouts;
typedef void (__stdcall *ETH_SET_COM_TIMEOUTS_AUTO_FP)(const double InitialTimeout, const double MaxTimeout, const double Multiplier, const UINT Mode);
extern ETH_SET_COM_TIMEOUTS_AUTO_FP eth_set_com_timeouts_auto;
typedef void (__stdcall *ETH_GET_COM_TIMEOUTS_AUTO_FP)(double* InitialTimeout, double* MaxTimeout, double* Multiplier, UINT* Mode);
extern ETH_GET_COM_TIMEOUTS_AUTO_FP eth_get_com_timeouts_auto;
typedef UINT (__stdcall *ETH_SET_HIGH_PERFORMANCE_MODE_FP)(const UINT Mode);
extern ETH_SET_HIGH_PERFORMANCE_MODE_FP eth_set_high_performance_mode;
typedef UINT (__stdcall *ETH_CHECK_CONNECTION_FP)(void);
extern ETH_CHECK_CONNECTION_FP eth_check_connection;
typedef void (__stdcall *SET_ETH_BOOT_CONTROL_FP)(const UINT Ctrl);
extern SET_ETH_BOOT_CONTROL_FP set_eth_boot_control;
typedef void (__stdcall *ETH_BOOT_TIMEOUT_FP)(const UINT Timeout);
extern ETH_BOOT_TIMEOUT_FP eth_boot_timeout;
typedef void (__stdcall *ETH_SET_REMOTE_TGM_FORMAT_FP)(const UINT Format);
extern ETH_SET_REMOTE_TGM_FORMAT_FP eth_set_remote_tgm_format;
typedef void (__stdcall *ETH_BOOT_DCMD_FP)(void);
extern ETH_BOOT_DCMD_FP eth_boot_dcmd;
typedef UINT (__stdcall *STORE_PROGRAM_FP)(const UINT Mode);
extern STORE_PROGRAM_FP store_program;
typedef UINT (__stdcall *READ_IMAGE_ETH_FP)(const char* Name);
extern READ_IMAGE_ETH_FP read_image_eth;
typedef UINT (__stdcall *WRITE_IMAGE_ETH_FP)(const char* Name);
extern WRITE_IMAGE_ETH_FP write_image_eth;
typedef void (__stdcall *ETH_CONFIGURE_LINK_LOSS_FP)(const UINT Mode);
extern ETH_CONFIGURE_LINK_LOSS_FP eth_configure_link_loss;
typedef void (__stdcall *ETH_GET_STANDALONE_STATUS_FP)(UINT* Status, UINT* Error, UINT* Mode);
extern ETH_GET_STANDALONE_STATUS_FP eth_get_standalone_status;
typedef void (__stdcall *ETH_CONFIG_WAVEFORM_STREAMING_CTRL_FP)(const UINT Size, const UINT Flags);
extern ETH_CONFIG_WAVEFORM_STREAMING_CTRL_FP eth_config_waveform_streaming_ctrl;
typedef UINT (__stdcall *READ_ABC_FROM_FILE_FP)(const char* Name, double* A, double* B, double* C);
extern READ_ABC_FROM_FILE_FP read_abc_from_file;
typedef UINT (__stdcall *WRITE_ABC_TO_FILE_FP)(const char* Name, const double A, const double B, const double C);
extern WRITE_ABC_TO_FILE_FP write_abc_to_file;
typedef UINT (__stdcall *READ_ABC_FROM_FILE_20B_FP)(const char* Name, double* A, double* B, double* C);
extern READ_ABC_FROM_FILE_20B_FP read_abc_from_file_20b;
typedef UINT (__stdcall *WRITE_ABC_TO_FILE_20B_FP)(const char* Name, const double A, const double B, const double C);
extern WRITE_ABC_TO_FILE_20B_FP write_abc_to_file_20b;
typedef UINT (__stdcall *N_CREATE_DAT_FILE_FP)(const UINT CardNo, const LONG Flag);
extern N_CREATE_DAT_FILE_FP n_create_dat_file;
typedef UINT (__stdcall *CREATE_DAT_FILE_FP)(const LONG Flag);
extern CREATE_DAT_FILE_FP create_dat_file;
typedef UINT (__stdcall *N_UPGRADE_BIOS_FP)(const UINT CardNo, const char* Name);
extern N_UPGRADE_BIOS_FP n_upgrade_bios;
typedef UINT (__stdcall *UPGRADE_BIOS_FP)(const char* Name);
extern UPGRADE_BIOS_FP upgrade_bios;
typedef UINT (__stdcall *TRANSFORM_FP)(LONG* Sig1, LONG* Sig2, const ULONG_PTR Ptr, const UINT Code);
extern TRANSFORM_FP transform;
typedef UINT (__stdcall *DEMUX_RCM_CTRL_FP)(const ULONG_PTR Input, const UINT Input_length, const UINT N_signals, const UINT Index, const UINT Flags, ULONG_PTR Output);
extern DEMUX_RCM_CTRL_FP demux_rcm_ctrl;
typedef UINT (__stdcall *RTC6_COUNT_CARDS_FP)(void);
extern RTC6_COUNT_CARDS_FP rtc6_count_cards;
typedef UINT (__stdcall *ACQUIRE_RTC_FP)(const UINT CardNo);
extern ACQUIRE_RTC_FP acquire_rtc;
typedef UINT (__stdcall *RELEASE_RTC_FP)(const UINT CardNo);
extern RELEASE_RTC_FP release_rtc;
typedef UINT (__stdcall *SELECT_RTC_FP)(const UINT CardNo);
extern SELECT_RTC_FP select_rtc;
typedef UINT (__stdcall *GET_DLL_VERSION_FP)(void);
extern GET_DLL_VERSION_FP get_dll_version;
typedef UINT (__stdcall *N_GET_CARD_TYPE_FP)(const UINT CardNo);
extern N_GET_CARD_TYPE_FP n_get_card_type;
typedef UINT (__stdcall *N_GET_SERIAL_NUMBER_FP)(const UINT CardNo);
extern N_GET_SERIAL_NUMBER_FP n_get_serial_number;
typedef UINT (__stdcall *N_GET_HEX_VERSION_FP)(const UINT CardNo);
extern N_GET_HEX_VERSION_FP n_get_hex_version;
typedef UINT (__stdcall *N_GET_RTC_VERSION_FP)(const UINT CardNo);
extern N_GET_RTC_VERSION_FP n_get_rtc_version;
typedef UINT (__stdcall *N_GET_BIOS_VERSION_FP)(const UINT CardNo);
extern N_GET_BIOS_VERSION_FP n_get_bios_version;
typedef UINT (__stdcall *GET_CARD_TYPE_FP)(void);
extern GET_CARD_TYPE_FP get_card_type;
typedef UINT (__stdcall *GET_SERIAL_NUMBER_FP)(void);
extern GET_SERIAL_NUMBER_FP get_serial_number;
typedef UINT (__stdcall *GET_HEX_VERSION_FP)(void);
extern GET_HEX_VERSION_FP get_hex_version;
typedef UINT (__stdcall *GET_RTC_VERSION_FP)(void);
extern GET_RTC_VERSION_FP get_rtc_version;
typedef UINT (__stdcall *GET_BIOS_VERSION_FP)(void);
extern GET_BIOS_VERSION_FP get_bios_version;
typedef UINT (__stdcall *N_LOAD_PROGRAM_FILE_FP)(const UINT CardNo, const char* Path);
extern N_LOAD_PROGRAM_FILE_FP n_load_program_file;
typedef void (__stdcall *N_SYNC_SLAVES_FP)(const UINT CardNo);
extern N_SYNC_SLAVES_FP n_sync_slaves;
typedef UINT (__stdcall *N_GET_SYNC_STATUS_FP)(const UINT CardNo);
extern N_GET_SYNC_STATUS_FP n_get_sync_status;
typedef void (__stdcall *N_MASTER_SLAVE_CONFIG_FP)(const UINT CardNo, const UINT Flags);
extern N_MASTER_SLAVE_CONFIG_FP n_master_slave_config;
typedef void (__stdcall *N_MASTER_SLAVE_SET_OFFSET_CTRL_FP)(const UINT CardNo, const UINT Mode, const UINT Ctrl);
extern N_MASTER_SLAVE_SET_OFFSET_CTRL_FP n_master_slave_set_offset_ctrl;
typedef UINT (__stdcall *N_LOAD_CORRECTION_FILE_FP)(const UINT CardNo, const char* Name, const UINT No, const UINT Dim);
extern N_LOAD_CORRECTION_FILE_FP n_load_correction_file;
typedef UINT (__stdcall *N_LOAD_ZOOM_CORRECTION_FILE_FP)(const UINT CardNo, const char* Name, const UINT No);
extern N_LOAD_ZOOM_CORRECTION_FILE_FP n_load_zoom_correction_file;
typedef UINT (__stdcall *N_LOAD_OCT_TABLE_NO_FP)(const UINT CardNo, const double A, const double B, const UINT No);
extern N_LOAD_OCT_TABLE_NO_FP n_load_oct_table_no;
typedef UINT (__stdcall *N_LOAD_Z_TABLE_NO_FP)(const UINT CardNo, const double A, const double B, const double C, const UINT No);
extern N_LOAD_Z_TABLE_NO_FP n_load_z_table_no;
typedef UINT (__stdcall *N_LOAD_Z_TABLE_FP)(const UINT CardNo, const double A, const double B, const double C);
extern N_LOAD_Z_TABLE_FP n_load_z_table;
typedef void (__stdcall *N_SELECT_COR_TABLE_FP)(const UINT CardNo, const UINT HeadA, const UINT HeadB);
extern N_SELECT_COR_TABLE_FP n_select_cor_table;
typedef UINT (__stdcall *N_SET_DSP_MODE_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_DSP_MODE_FP n_set_dsp_mode;
typedef LONG (__stdcall *N_LOAD_STRETCH_TABLE_FP)(const UINT CardNo, const char* Name, const LONG No, const UINT TableNo);
extern N_LOAD_STRETCH_TABLE_FP n_load_stretch_table;
typedef void (__stdcall *N_NUMBER_OF_CORRECTION_TABLES_FP)(const UINT CardNo, const UINT Number);
extern N_NUMBER_OF_CORRECTION_TABLES_FP n_number_of_correction_tables;
typedef UINT (__stdcall *N_LOAD_Z_TABLE_NO_20B_FP)(const UINT CardNo, const double A, const double B, const double C, const UINT No);
extern N_LOAD_Z_TABLE_NO_20B_FP n_load_z_table_no_20b;
typedef UINT (__stdcall *N_LOAD_Z_TABLE_20B_FP)(const UINT CardNo, const double A, const double B, const double C);
extern N_LOAD_Z_TABLE_20B_FP n_load_z_table_20b;
typedef double (__stdcall *N_GET_HEAD_PARA_FP)(const UINT CardNo, const UINT HeadNo, const UINT ParaNo);
extern N_GET_HEAD_PARA_FP n_get_head_para;
typedef double (__stdcall *N_GET_TABLE_PARA_FP)(const UINT CardNo, const UINT TableNo, const UINT ParaNo);
extern N_GET_TABLE_PARA_FP n_get_table_para;
typedef UINT (__stdcall *LOAD_PROGRAM_FILE_FP)(const char* Path);
extern LOAD_PROGRAM_FILE_FP load_program_file;
typedef void (__stdcall *SYNC_SLAVES_FP)(void);
extern SYNC_SLAVES_FP sync_slaves;
typedef UINT (__stdcall *GET_SYNC_STATUS_FP)(void);
extern GET_SYNC_STATUS_FP get_sync_status;
typedef void (__stdcall *MASTER_SLAVE_CONFIG_FP)(const UINT Flags);
extern MASTER_SLAVE_CONFIG_FP master_slave_config;
typedef void (__stdcall *MASTER_SLAVE_SET_OFFSET_CTRL_FP)(const UINT Mode, const UINT Ctrl);
extern MASTER_SLAVE_SET_OFFSET_CTRL_FP master_slave_set_offset_ctrl;
typedef UINT (__stdcall *LOAD_CORRECTION_FILE_FP)(const char* Name, const UINT No, const UINT Dim);
extern LOAD_CORRECTION_FILE_FP load_correction_file;
typedef UINT (__stdcall *LOAD_ZOOM_CORRECTION_FILE_FP)(const char* Name, const UINT No);
extern LOAD_ZOOM_CORRECTION_FILE_FP load_zoom_correction_file;
typedef UINT (__stdcall *LOAD_OCT_TABLE_NO_FP)(const double A, const double B, const UINT No);
extern LOAD_OCT_TABLE_NO_FP load_oct_table_no;
typedef UINT (__stdcall *LOAD_Z_TABLE_NO_FP)(const double A, const double B, const double C, const UINT No);
extern LOAD_Z_TABLE_NO_FP load_z_table_no;
typedef UINT (__stdcall *LOAD_Z_TABLE_FP)(const double A, const double B, const double C);
extern LOAD_Z_TABLE_FP load_z_table;
typedef void (__stdcall *SELECT_COR_TABLE_FP)(const UINT HeadA, const UINT HeadB);
extern SELECT_COR_TABLE_FP select_cor_table;
typedef UINT (__stdcall *SET_DSP_MODE_FP)(const UINT Mode);
extern SET_DSP_MODE_FP set_dsp_mode;
typedef LONG (__stdcall *LOAD_STRETCH_TABLE_FP)(const char* Name, const LONG No, const UINT TableNo);
extern LOAD_STRETCH_TABLE_FP load_stretch_table;
typedef void (__stdcall *NUMBER_OF_CORRECTION_TABLES_FP)(const UINT Number);
extern NUMBER_OF_CORRECTION_TABLES_FP number_of_correction_tables;
typedef UINT (__stdcall *LOAD_Z_TABLE_NO_20B_FP)(const double A, const double B, const double C, const UINT No);
extern LOAD_Z_TABLE_NO_20B_FP load_z_table_no_20b;
typedef UINT (__stdcall *LOAD_Z_TABLE_20B_FP)(const double A, const double B, const double C);
extern LOAD_Z_TABLE_20B_FP load_z_table_20b;
typedef double (__stdcall *GET_HEAD_PARA_FP)(const UINT HeadNo, const UINT ParaNo);
extern GET_HEAD_PARA_FP get_head_para;
typedef double (__stdcall *GET_TABLE_PARA_FP)(const UINT TableNo, const UINT ParaNo);
extern GET_TABLE_PARA_FP get_table_para;
typedef void (__stdcall *N_CONFIG_LIST_FP)(const UINT CardNo, const UINT Mem1, const UINT Mem2);
extern N_CONFIG_LIST_FP n_config_list;
typedef void (__stdcall *N_GET_CONFIG_LIST_FP)(const UINT CardNo);
extern N_GET_CONFIG_LIST_FP n_get_config_list;
typedef UINT (__stdcall *N_SAVE_DISK_FP)(const UINT CardNo, const char* Name, const UINT Mode);
extern N_SAVE_DISK_FP n_save_disk;
typedef UINT (__stdcall *N_LOAD_DISK_FP)(const UINT CardNo, const char* Name, const UINT Mode);
extern N_LOAD_DISK_FP n_load_disk;
typedef UINT (__stdcall *N_GET_LIST_SPACE_FP)(const UINT CardNo);
extern N_GET_LIST_SPACE_FP n_get_list_space;
typedef void (__stdcall *CONFIG_LIST_FP)(const UINT Mem1, const UINT Mem2);
extern CONFIG_LIST_FP config_list;
typedef void (__stdcall *GET_CONFIG_LIST_FP)(void);
extern GET_CONFIG_LIST_FP get_config_list;
typedef UINT (__stdcall *SAVE_DISK_FP)(const char* Name, const UINT Mode);
extern SAVE_DISK_FP save_disk;
typedef UINT (__stdcall *LOAD_DISK_FP)(const char* Name, const UINT Mode);
extern LOAD_DISK_FP load_disk;
typedef UINT (__stdcall *GET_LIST_SPACE_FP)(void);
extern GET_LIST_SPACE_FP get_list_space;
typedef void (__stdcall *N_SET_START_LIST_POS_FP)(const UINT CardNo, const UINT ListNo, const UINT Pos);
extern N_SET_START_LIST_POS_FP n_set_start_list_pos;
typedef void (__stdcall *N_SET_START_LIST_FP)(const UINT CardNo, const UINT ListNo);
extern N_SET_START_LIST_FP n_set_start_list;
typedef void (__stdcall *N_SET_START_LIST_1_FP)(const UINT CardNo);
extern N_SET_START_LIST_1_FP n_set_start_list_1;
typedef void (__stdcall *N_SET_START_LIST_2_FP)(const UINT CardNo);
extern N_SET_START_LIST_2_FP n_set_start_list_2;
typedef void (__stdcall *N_SET_INPUT_POINTER_FP)(const UINT CardNo, const UINT Pos);
extern N_SET_INPUT_POINTER_FP n_set_input_pointer;
typedef UINT (__stdcall *N_LOAD_LIST_FP)(const UINT CardNo, const UINT ListNo, const UINT Pos);
extern N_LOAD_LIST_FP n_load_list;
typedef void (__stdcall *N_LOAD_SUB_FP)(const UINT CardNo, const UINT Index);
extern N_LOAD_SUB_FP n_load_sub;
typedef void (__stdcall *N_LOAD_CHAR_FP)(const UINT CardNo, const UINT Char);
extern N_LOAD_CHAR_FP n_load_char;
typedef void (__stdcall *N_LOAD_TEXT_TABLE_FP)(const UINT CardNo, const UINT Index);
extern N_LOAD_TEXT_TABLE_FP n_load_text_table;
typedef void (__stdcall *N_GET_LIST_POINTER_FP)(const UINT CardNo, UINT* ListNo, UINT* Pos);
extern N_GET_LIST_POINTER_FP n_get_list_pointer;
typedef UINT (__stdcall *N_GET_INPUT_POINTER_FP)(const UINT CardNo);
extern N_GET_INPUT_POINTER_FP n_get_input_pointer;
typedef void (__stdcall *SET_START_LIST_POS_FP)(const UINT ListNo, const UINT Pos);
extern SET_START_LIST_POS_FP set_start_list_pos;
typedef void (__stdcall *SET_START_LIST_FP)(const UINT ListNo);
extern SET_START_LIST_FP set_start_list;
typedef void (__stdcall *SET_START_LIST_1_FP)(void);
extern SET_START_LIST_1_FP set_start_list_1;
typedef void (__stdcall *SET_START_LIST_2_FP)(void);
extern SET_START_LIST_2_FP set_start_list_2;
typedef void (__stdcall *SET_INPUT_POINTER_FP)(const UINT Pos);
extern SET_INPUT_POINTER_FP set_input_pointer;
typedef UINT (__stdcall *LOAD_LIST_FP)(const UINT ListNo, const UINT Pos);
extern LOAD_LIST_FP load_list;
typedef void (__stdcall *LOAD_SUB_FP)(const UINT Index);
extern LOAD_SUB_FP load_sub;
typedef void (__stdcall *LOAD_CHAR_FP)(const UINT Char);
extern LOAD_CHAR_FP load_char;
typedef void (__stdcall *LOAD_TEXT_TABLE_FP)(const UINT Index);
extern LOAD_TEXT_TABLE_FP load_text_table;
typedef void (__stdcall *GET_LIST_POINTER_FP)(UINT* ListNo, UINT* Pos);
extern GET_LIST_POINTER_FP get_list_pointer;
typedef UINT (__stdcall *GET_INPUT_POINTER_FP)(void);
extern GET_INPUT_POINTER_FP get_input_pointer;
typedef void (__stdcall *N_EXECUTE_LIST_POS_FP)(const UINT CardNo, const UINT ListNo, const UINT Pos);
extern N_EXECUTE_LIST_POS_FP n_execute_list_pos;
typedef void (__stdcall *N_EXECUTE_AT_POINTER_FP)(const UINT CardNo, const UINT Pos);
extern N_EXECUTE_AT_POINTER_FP n_execute_at_pointer;
typedef void (__stdcall *N_EXECUTE_LIST_FP)(const UINT CardNo, const UINT ListNo);
extern N_EXECUTE_LIST_FP n_execute_list;
typedef void (__stdcall *N_EXECUTE_LIST_1_FP)(const UINT CardNo);
extern N_EXECUTE_LIST_1_FP n_execute_list_1;
typedef void (__stdcall *N_EXECUTE_LIST_2_FP)(const UINT CardNo);
extern N_EXECUTE_LIST_2_FP n_execute_list_2;
typedef UINT (__stdcall *N_LIST_JUMP_REL_CTRL_FP)(const UINT CardNo, const LONG Pos);
extern N_LIST_JUMP_REL_CTRL_FP n_list_jump_rel_ctrl;
typedef void (__stdcall *N_GET_OUT_POINTER_FP)(const UINT CardNo, UINT* ListNo, UINT* Pos);
extern N_GET_OUT_POINTER_FP n_get_out_pointer;
typedef void (__stdcall *EXECUTE_LIST_POS_FP)(const UINT ListNo, const UINT Pos);
extern EXECUTE_LIST_POS_FP execute_list_pos;
typedef void (__stdcall *EXECUTE_AT_POINTER_FP)(const UINT Pos);
extern EXECUTE_AT_POINTER_FP execute_at_pointer;
typedef void (__stdcall *EXECUTE_LIST_FP)(const UINT ListNo);
extern EXECUTE_LIST_FP execute_list;
typedef void (__stdcall *EXECUTE_LIST_1_FP)(void);
extern EXECUTE_LIST_1_FP execute_list_1;
typedef void (__stdcall *EXECUTE_LIST_2_FP)(void);
extern EXECUTE_LIST_2_FP execute_list_2;
typedef UINT (__stdcall *LIST_JUMP_REL_CTRL_FP)(const LONG Pos);
extern LIST_JUMP_REL_CTRL_FP list_jump_rel_ctrl;
typedef void (__stdcall *GET_OUT_POINTER_FP)(UINT* ListNo, UINT* Pos);
extern GET_OUT_POINTER_FP get_out_pointer;
typedef void (__stdcall *N_AUTO_CHANGE_POS_FP)(const UINT CardNo, const UINT Pos);
extern N_AUTO_CHANGE_POS_FP n_auto_change_pos;
typedef void (__stdcall *N_START_LOOP_FP)(const UINT CardNo);
extern N_START_LOOP_FP n_start_loop;
typedef void (__stdcall *N_QUIT_LOOP_FP)(const UINT CardNo);
extern N_QUIT_LOOP_FP n_quit_loop;
typedef void (__stdcall *N_PAUSE_LIST_FP)(const UINT CardNo);
extern N_PAUSE_LIST_FP n_pause_list;
typedef void (__stdcall *N_RESTART_LIST_FP)(const UINT CardNo);
extern N_RESTART_LIST_FP n_restart_list;
typedef void (__stdcall *N_RELEASE_WAIT_FP)(const UINT CardNo);
extern N_RELEASE_WAIT_FP n_release_wait;
typedef void (__stdcall *N_STOP_EXECUTION_FP)(const UINT CardNo);
extern N_STOP_EXECUTION_FP n_stop_execution;
typedef void (__stdcall *N_SET_PAUSE_LIST_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_SET_PAUSE_LIST_COND_FP n_set_pause_list_cond;
typedef void (__stdcall *N_SET_PAUSE_LIST_NOT_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_SET_PAUSE_LIST_NOT_COND_FP n_set_pause_list_not_cond;
typedef void (__stdcall *N_AUTO_CHANGE_FP)(const UINT CardNo);
extern N_AUTO_CHANGE_FP n_auto_change;
typedef void (__stdcall *N_STOP_LIST_FP)(const UINT CardNo);
extern N_STOP_LIST_FP n_stop_list;
typedef UINT (__stdcall *N_GET_WAIT_STATUS_FP)(const UINT CardNo);
extern N_GET_WAIT_STATUS_FP n_get_wait_status;
typedef UINT (__stdcall *N_READ_STATUS_FP)(const UINT CardNo);
extern N_READ_STATUS_FP n_read_status;
typedef void (__stdcall *N_GET_STATUS_FP)(const UINT CardNo, UINT* Status, UINT* Pos);
extern N_GET_STATUS_FP n_get_status;
typedef void (__stdcall *N_SET_SHORT_CMD_MODE_CTRL_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_SHORT_CMD_MODE_CTRL_FP n_set_short_cmd_mode_ctrl;
typedef void (__stdcall *AUTO_CHANGE_POS_FP)(const UINT Pos);
extern AUTO_CHANGE_POS_FP auto_change_pos;
typedef void (__stdcall *START_LOOP_FP)(void);
extern START_LOOP_FP start_loop;
typedef void (__stdcall *QUIT_LOOP_FP)(void);
extern QUIT_LOOP_FP quit_loop;
typedef void (__stdcall *PAUSE_LIST_FP)(void);
extern PAUSE_LIST_FP pause_list;
typedef void (__stdcall *RESTART_LIST_FP)(void);
extern RESTART_LIST_FP restart_list;
typedef void (__stdcall *RELEASE_WAIT_FP)(void);
extern RELEASE_WAIT_FP release_wait;
typedef void (__stdcall *STOP_EXECUTION_FP)(void);
extern STOP_EXECUTION_FP stop_execution;
typedef void (__stdcall *SET_PAUSE_LIST_COND_FP)(const UINT Mask1, const UINT Mask0);
extern SET_PAUSE_LIST_COND_FP set_pause_list_cond;
typedef void (__stdcall *SET_PAUSE_LIST_NOT_COND_FP)(const UINT Mask1, const UINT Mask0);
extern SET_PAUSE_LIST_NOT_COND_FP set_pause_list_not_cond;
typedef void (__stdcall *AUTO_CHANGE_FP)(void);
extern AUTO_CHANGE_FP auto_change;
typedef void (__stdcall *STOP_LIST_FP)(void);
extern STOP_LIST_FP stop_list;
typedef UINT (__stdcall *GET_WAIT_STATUS_FP)(void);
extern GET_WAIT_STATUS_FP get_wait_status;
typedef UINT (__stdcall *READ_STATUS_FP)(void);
extern READ_STATUS_FP read_status;
typedef void (__stdcall *GET_STATUS_FP)(UINT* Status, UINT* Pos);
extern GET_STATUS_FP get_status;
typedef void (__stdcall *SET_SHORT_CMD_MODE_CTRL_FP)(const UINT Mode);
extern SET_SHORT_CMD_MODE_CTRL_FP set_short_cmd_mode_ctrl;
typedef void (__stdcall *N_SET_EXTSTARTPOS_FP)(const UINT CardNo, const UINT Pos);
extern N_SET_EXTSTARTPOS_FP n_set_extstartpos;
typedef void (__stdcall *N_SET_MAX_COUNTS_FP)(const UINT CardNo, const UINT Counts);
extern N_SET_MAX_COUNTS_FP n_set_max_counts;
typedef void (__stdcall *N_SET_CONTROL_MODE_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_CONTROL_MODE_FP n_set_control_mode;
typedef void (__stdcall *N_SIMULATE_EXT_STOP_FP)(const UINT CardNo);
extern N_SIMULATE_EXT_STOP_FP n_simulate_ext_stop;
typedef void (__stdcall *N_SIMULATE_EXT_START_CTRL_FP)(const UINT CardNo);
extern N_SIMULATE_EXT_START_CTRL_FP n_simulate_ext_start_ctrl;
typedef void (__stdcall *N_STORE_TIMESTAMP_COUNTER_FP)(const UINT CardNo);
extern N_STORE_TIMESTAMP_COUNTER_FP n_store_timestamp_counter;
typedef void (__stdcall *N_GET_TIMESTAMP_LONG_FP)(const UINT CardNo, UINT* TimeStampL, UINT* TimeStampH);
extern N_GET_TIMESTAMP_LONG_FP n_get_timestamp_long;
typedef UINT (__stdcall *N_GET_COUNTS_FP)(const UINT CardNo);
extern N_GET_COUNTS_FP n_get_counts;
typedef UINT (__stdcall *N_GET_STARTSTOP_INFO_FP)(const UINT CardNo);
extern N_GET_STARTSTOP_INFO_FP n_get_startstop_info;
typedef void (__stdcall *SET_EXTSTARTPOS_FP)(const UINT Pos);
extern SET_EXTSTARTPOS_FP set_extstartpos;
typedef void (__stdcall *SET_MAX_COUNTS_FP)(const UINT Counts);
extern SET_MAX_COUNTS_FP set_max_counts;
typedef void (__stdcall *SET_CONTROL_MODE_FP)(const UINT Mode);
extern SET_CONTROL_MODE_FP set_control_mode;
typedef void (__stdcall *SIMULATE_EXT_STOP_FP)(void);
extern SIMULATE_EXT_STOP_FP simulate_ext_stop;
typedef void (__stdcall *SIMULATE_EXT_START_CTRL_FP)(void);
extern SIMULATE_EXT_START_CTRL_FP simulate_ext_start_ctrl;
typedef void (__stdcall *STORE_TIMESTAMP_COUNTER_FP)(void);
extern STORE_TIMESTAMP_COUNTER_FP store_timestamp_counter;
typedef void (__stdcall *GET_TIMESTAMP_LONG_FP)(UINT* TimeStampL, UINT* TimeStampH);
extern GET_TIMESTAMP_LONG_FP get_timestamp_long;
typedef UINT (__stdcall *GET_COUNTS_FP)(void);
extern GET_COUNTS_FP get_counts;
typedef UINT (__stdcall *GET_STARTSTOP_INFO_FP)(void);
extern GET_STARTSTOP_INFO_FP get_startstop_info;
typedef void (__stdcall *N_COPY_DST_SRC_FP)(const UINT CardNo, const UINT Dst, const UINT Src, const UINT Mode);
extern N_COPY_DST_SRC_FP n_copy_dst_src;
typedef void (__stdcall *N_SET_CHAR_POINTER_FP)(const UINT CardNo, const UINT Char, const UINT Pos);
extern N_SET_CHAR_POINTER_FP n_set_char_pointer;
typedef void (__stdcall *N_SET_SUB_POINTER_FP)(const UINT CardNo, const UINT Index, const UINT Pos);
extern N_SET_SUB_POINTER_FP n_set_sub_pointer;
typedef void (__stdcall *N_SET_TEXT_TABLE_POINTER_FP)(const UINT CardNo, const UINT Index, const UINT Pos);
extern N_SET_TEXT_TABLE_POINTER_FP n_set_text_table_pointer;
typedef void (__stdcall *N_SET_CHAR_TABLE_FP)(const UINT CardNo, const UINT Index, const UINT Pos);
extern N_SET_CHAR_TABLE_FP n_set_char_table;
typedef UINT (__stdcall *N_GET_CHAR_POINTER_FP)(const UINT CardNo, const UINT Char);
extern N_GET_CHAR_POINTER_FP n_get_char_pointer;
typedef UINT (__stdcall *N_GET_SUB_POINTER_FP)(const UINT CardNo, const UINT Index);
extern N_GET_SUB_POINTER_FP n_get_sub_pointer;
typedef UINT (__stdcall *N_GET_TEXT_TABLE_POINTER_FP)(const UINT CardNo, const UINT Index);
extern N_GET_TEXT_TABLE_POINTER_FP n_get_text_table_pointer;
typedef void (__stdcall *COPY_DST_SRC_FP)(const UINT Dst, const UINT Src, const UINT Mode);
extern COPY_DST_SRC_FP copy_dst_src;
typedef void (__stdcall *SET_CHAR_POINTER_FP)(const UINT Char, const UINT Pos);
extern SET_CHAR_POINTER_FP set_char_pointer;
typedef void (__stdcall *SET_SUB_POINTER_FP)(const UINT Index, const UINT Pos);
extern SET_SUB_POINTER_FP set_sub_pointer;
typedef void (__stdcall *SET_TEXT_TABLE_POINTER_FP)(const UINT Index, const UINT Pos);
extern SET_TEXT_TABLE_POINTER_FP set_text_table_pointer;
typedef void (__stdcall *SET_CHAR_TABLE_FP)(const UINT Index, const UINT Pos);
extern SET_CHAR_TABLE_FP set_char_table;
typedef UINT (__stdcall *GET_CHAR_POINTER_FP)(const UINT Char);
extern GET_CHAR_POINTER_FP get_char_pointer;
typedef UINT (__stdcall *GET_SUB_POINTER_FP)(const UINT Index);
extern GET_SUB_POINTER_FP get_sub_pointer;
typedef UINT (__stdcall *GET_TEXT_TABLE_POINTER_FP)(const UINT Index);
extern GET_TEXT_TABLE_POINTER_FP get_text_table_pointer;
typedef void (__stdcall *N_TIME_UPDATE_FP)(const UINT CardNo);
extern N_TIME_UPDATE_FP n_time_update;
typedef void (__stdcall *N_TIME_CONTROL_ETH_FP)(const UINT CardNo, const double PPM);
extern N_TIME_CONTROL_ETH_FP n_time_control_eth;
typedef void (__stdcall *N_SET_SERIAL_STEP_FP)(const UINT CardNo, const UINT No, const UINT Step);
extern N_SET_SERIAL_STEP_FP n_set_serial_step;
typedef void (__stdcall *N_SELECT_SERIAL_SET_FP)(const UINT CardNo, const UINT No);
extern N_SELECT_SERIAL_SET_FP n_select_serial_set;
typedef void (__stdcall *N_SET_SERIAL_FP)(const UINT CardNo, const UINT No);
extern N_SET_SERIAL_FP n_set_serial;
typedef double (__stdcall *N_GET_SERIAL_FP)(const UINT CardNo);
extern N_GET_SERIAL_FP n_get_serial;
typedef double (__stdcall *N_GET_LIST_SERIAL_FP)(const UINT CardNo, UINT* SetNo);
extern N_GET_LIST_SERIAL_FP n_get_list_serial;
typedef void (__stdcall *TIME_UPDATE_FP)(void);
extern TIME_UPDATE_FP time_update;
typedef void (__stdcall *TIME_CONTROL_ETH_FP)(const double PPM);
extern TIME_CONTROL_ETH_FP time_control_eth;
typedef void (__stdcall *SET_SERIAL_STEP_FP)(const UINT No, const UINT Step);
extern SET_SERIAL_STEP_FP set_serial_step;
typedef void (__stdcall *SELECT_SERIAL_SET_FP)(const UINT No);
extern SELECT_SERIAL_SET_FP select_serial_set;
typedef void (__stdcall *SET_SERIAL_FP)(const UINT No);
extern SET_SERIAL_FP set_serial;
typedef double (__stdcall *GET_SERIAL_FP)(void);
extern GET_SERIAL_FP get_serial;
typedef double (__stdcall *GET_LIST_SERIAL_FP)(UINT* SetNo);
extern GET_LIST_SERIAL_FP get_list_serial;
typedef void (__stdcall *N_WRITE_IO_PORT_MASK_FP)(const UINT CardNo, const UINT Value, const UINT Mask);
extern N_WRITE_IO_PORT_MASK_FP n_write_io_port_mask;
typedef void (__stdcall *N_WRITE_8BIT_PORT_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_8BIT_PORT_FP n_write_8bit_port;
typedef UINT (__stdcall *N_READ_IO_PORT_FP)(const UINT CardNo);
extern N_READ_IO_PORT_FP n_read_io_port;
typedef UINT (__stdcall *N_READ_IO_PORT_BUFFER_FP)(const UINT CardNo, const UINT Index, UINT* Value, LONG* XPos, LONG* YPos, UINT* Time);
extern N_READ_IO_PORT_BUFFER_FP n_read_io_port_buffer;
typedef UINT (__stdcall *N_GET_IO_STATUS_FP)(const UINT CardNo);
extern N_GET_IO_STATUS_FP n_get_io_status;
typedef UINT (__stdcall *N_READ_ANALOG_IN_FP)(const UINT CardNo);
extern N_READ_ANALOG_IN_FP n_read_analog_in;
typedef void (__stdcall *N_WRITE_DA_X_FP)(const UINT CardNo, const UINT x, const UINT Value);
extern N_WRITE_DA_X_FP n_write_da_x;
typedef void (__stdcall *N_SET_LASER_OFF_DEFAULT_FP)(const UINT CardNo, const UINT AnalogOut1, const UINT AnalogOut2, const UINT DigitalOut);
extern N_SET_LASER_OFF_DEFAULT_FP n_set_laser_off_default;
typedef void (__stdcall *N_SET_PORT_DEFAULT_FP)(const UINT CardNo, const UINT Port, const UINT Value);
extern N_SET_PORT_DEFAULT_FP n_set_port_default;
typedef void (__stdcall *N_WRITE_IO_PORT_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_IO_PORT_FP n_write_io_port;
typedef void (__stdcall *N_WRITE_DA_1_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_DA_1_FP n_write_da_1;
typedef void (__stdcall *N_WRITE_DA_2_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_DA_2_FP n_write_da_2;
typedef void (__stdcall *WRITE_IO_PORT_MASK_FP)(const UINT Value, const UINT Mask);
extern WRITE_IO_PORT_MASK_FP write_io_port_mask;
typedef void (__stdcall *WRITE_8BIT_PORT_FP)(const UINT Value);
extern WRITE_8BIT_PORT_FP write_8bit_port;
typedef UINT (__stdcall *READ_IO_PORT_FP)(void);
extern READ_IO_PORT_FP read_io_port;
typedef UINT (__stdcall *READ_IO_PORT_BUFFER_FP)(const UINT Index, UINT* Value, LONG* XPos, LONG* YPos, UINT* Time);
extern READ_IO_PORT_BUFFER_FP read_io_port_buffer;
typedef UINT (__stdcall *GET_IO_STATUS_FP)(void);
extern GET_IO_STATUS_FP get_io_status;
typedef UINT (__stdcall *READ_ANALOG_IN_FP)(void);
extern READ_ANALOG_IN_FP read_analog_in;
typedef void (__stdcall *WRITE_DA_X_FP)(const UINT x, const UINT Value);
extern WRITE_DA_X_FP write_da_x;
typedef void (__stdcall *SET_LASER_OFF_DEFAULT_FP)(const UINT AnalogOut1, const UINT AnalogOut2, const UINT DigitalOut);
extern SET_LASER_OFF_DEFAULT_FP set_laser_off_default;
typedef void (__stdcall *SET_PORT_DEFAULT_FP)(const UINT Port, const UINT Value);
extern SET_PORT_DEFAULT_FP set_port_default;
typedef void (__stdcall *WRITE_IO_PORT_FP)(const UINT Value);
extern WRITE_IO_PORT_FP write_io_port;
typedef void (__stdcall *WRITE_DA_1_FP)(const UINT Value);
extern WRITE_DA_1_FP write_da_1;
typedef void (__stdcall *WRITE_DA_2_FP)(const UINT Value);
extern WRITE_DA_2_FP write_da_2;
typedef void (__stdcall *N_DISABLE_LASER_FP)(const UINT CardNo);
extern N_DISABLE_LASER_FP n_disable_laser;
typedef void (__stdcall *N_ENABLE_LASER_FP)(const UINT CardNo);
extern N_ENABLE_LASER_FP n_enable_laser;
typedef void (__stdcall *N_LASER_SIGNAL_ON_FP)(const UINT CardNo);
extern N_LASER_SIGNAL_ON_FP n_laser_signal_on;
typedef void (__stdcall *N_LASER_SIGNAL_OFF_FP)(const UINT CardNo);
extern N_LASER_SIGNAL_OFF_FP n_laser_signal_off;
typedef void (__stdcall *N_SET_STANDBY_FP)(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
extern N_SET_STANDBY_FP n_set_standby;
typedef void (__stdcall *N_SET_LASER_PULSES_CTRL_FP)(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
extern N_SET_LASER_PULSES_CTRL_FP n_set_laser_pulses_ctrl;
typedef void (__stdcall *N_SET_FIRSTPULSE_KILLER_FP)(const UINT CardNo, const UINT Length);
extern N_SET_FIRSTPULSE_KILLER_FP n_set_firstpulse_killer;
typedef void (__stdcall *N_SET_QSWITCH_DELAY_FP)(const UINT CardNo, const UINT Delay);
extern N_SET_QSWITCH_DELAY_FP n_set_qswitch_delay;
typedef void (__stdcall *N_SET_LASER_MODE_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_LASER_MODE_FP n_set_laser_mode;
typedef void (__stdcall *N_SET_LASER_CONTROL_FP)(const UINT CardNo, const UINT Ctrl);
extern N_SET_LASER_CONTROL_FP n_set_laser_control;
typedef void (__stdcall *N_SET_LASER_PIN_OUT_FP)(const UINT CardNo, const UINT Pins);
extern N_SET_LASER_PIN_OUT_FP n_set_laser_pin_out;
typedef UINT (__stdcall *N_GET_LASER_PIN_IN_FP)(const UINT CardNo);
extern N_GET_LASER_PIN_IN_FP n_get_laser_pin_in;
typedef void (__stdcall *N_SET_SOFTSTART_LEVEL_FP)(const UINT CardNo, const UINT Index, const UINT Level);
extern N_SET_SOFTSTART_LEVEL_FP n_set_softstart_level;
typedef void (__stdcall *N_SET_SOFTSTART_MODE_FP)(const UINT CardNo, const UINT Mode, const UINT Number, const UINT Delay);
extern N_SET_SOFTSTART_MODE_FP n_set_softstart_mode;
typedef UINT (__stdcall *N_SET_AUTO_LASER_CONTROL_FP)(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT Mode, const UINT MinValue, const UINT MaxValue);
extern N_SET_AUTO_LASER_CONTROL_FP n_set_auto_laser_control;
typedef UINT (__stdcall *N_SET_AUTO_LASER_PARAMS_FP)(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern N_SET_AUTO_LASER_PARAMS_FP n_set_auto_laser_params;
typedef LONG (__stdcall *N_LOAD_AUTO_LASER_CONTROL_FP)(const UINT CardNo, const char* Name, const UINT No);
extern N_LOAD_AUTO_LASER_CONTROL_FP n_load_auto_laser_control;
typedef LONG (__stdcall *N_LOAD_POSITION_CONTROL_FP)(const UINT CardNo, const char* Name, const UINT No);
extern N_LOAD_POSITION_CONTROL_FP n_load_position_control;
typedef UINT (__stdcall *N_LOAD_POSITION_CONTROL_2D_CTRL_FP)(const UINT CardNo, const char* Name);
extern N_LOAD_POSITION_CONTROL_2D_CTRL_FP n_load_position_control_2d_ctrl;
typedef void (__stdcall *N_SET_DEFAULT_PIXEL_FP)(const UINT CardNo, const UINT PulseLength);
extern N_SET_DEFAULT_PIXEL_FP n_set_default_pixel;
typedef void (__stdcall *N_GET_STANDBY_FP)(const UINT CardNo, UINT* HalfPeriod, UINT* PulseLength);
extern N_GET_STANDBY_FP n_get_standby;
typedef void (__stdcall *N_SET_PULSE_PICKING_FP)(const UINT CardNo, const UINT No);
extern N_SET_PULSE_PICKING_FP n_set_pulse_picking;
typedef void (__stdcall *N_SET_PULSE_PICKING_LENGTH_FP)(const UINT CardNo, const UINT Length);
extern N_SET_PULSE_PICKING_LENGTH_FP n_set_pulse_picking_length;
typedef void (__stdcall *N_CONFIG_LASER_SIGNALS_FP)(const UINT CardNo, const UINT Config);
extern N_CONFIG_LASER_SIGNALS_FP n_config_laser_signals;
typedef void (__stdcall *N_SPOT_DISTANCE_CTRL_FP)(const UINT CardNo, const double Dist);
extern N_SPOT_DISTANCE_CTRL_FP n_spot_distance_ctrl;
typedef void (__stdcall *N_SET_LASER_PULSE_FORM_FP)(const UINT CardNo, const UINT Mode, const UINT Length);
extern N_SET_LASER_PULSE_FORM_FP n_set_laser_pulse_form;
typedef void (__stdcall *N_SET_LASER_PULSE_SYNC_FP)(const UINT CardNo, const UINT Mode, const UINT Delay);
extern N_SET_LASER_PULSE_SYNC_FP n_set_laser_pulse_sync;
typedef void (__stdcall *N_SET_CONTROLPREVIEW_COMPENSATION_CTRL_FP)(const UINT CardNo, const UINT ControlPreview, const UINT Mode);
extern N_SET_CONTROLPREVIEW_COMPENSATION_CTRL_FP n_set_controlpreview_compensation_ctrl;
typedef void (__stdcall *N_SET_LASER_DELAYS_CTRL_FP)(const UINT CardNo, const LONG LaserOnDelay, const UINT LaserOffDelay);
extern N_SET_LASER_DELAYS_CTRL_FP n_set_laser_delays_ctrl;
typedef void (__stdcall *DISABLE_LASER_FP)(void);
extern DISABLE_LASER_FP disable_laser;
typedef void (__stdcall *ENABLE_LASER_FP)(void);
extern ENABLE_LASER_FP enable_laser;
typedef void (__stdcall *LASER_SIGNAL_ON_FP)(void);
extern LASER_SIGNAL_ON_FP laser_signal_on;
typedef void (__stdcall *LASER_SIGNAL_OFF_FP)(void);
extern LASER_SIGNAL_OFF_FP laser_signal_off;
typedef void (__stdcall *SET_STANDBY_FP)(const UINT HalfPeriod, const UINT PulseLength);
extern SET_STANDBY_FP set_standby;
typedef void (__stdcall *SET_LASER_PULSES_CTRL_FP)(const UINT HalfPeriod, const UINT PulseLength);
extern SET_LASER_PULSES_CTRL_FP set_laser_pulses_ctrl;
typedef void (__stdcall *SET_FIRSTPULSE_KILLER_FP)(const UINT Length);
extern SET_FIRSTPULSE_KILLER_FP set_firstpulse_killer;
typedef void (__stdcall *SET_QSWITCH_DELAY_FP)(const UINT Delay);
extern SET_QSWITCH_DELAY_FP set_qswitch_delay;
typedef void (__stdcall *SET_LASER_MODE_FP)(const UINT Mode);
extern SET_LASER_MODE_FP set_laser_mode;
typedef void (__stdcall *SET_LASER_CONTROL_FP)(const UINT Ctrl);
extern SET_LASER_CONTROL_FP set_laser_control;
typedef void (__stdcall *SET_LASER_PIN_OUT_FP)(const UINT Pins);
extern SET_LASER_PIN_OUT_FP set_laser_pin_out;
typedef UINT (__stdcall *GET_LASER_PIN_IN_FP)(void);
extern GET_LASER_PIN_IN_FP get_laser_pin_in;
typedef void (__stdcall *SET_SOFTSTART_LEVEL_FP)(const UINT Index, const UINT Level);
extern SET_SOFTSTART_LEVEL_FP set_softstart_level;
typedef void (__stdcall *SET_SOFTSTART_MODE_FP)(const UINT Mode, const UINT Number, const UINT Delay);
extern SET_SOFTSTART_MODE_FP set_softstart_mode;
typedef UINT (__stdcall *SET_AUTO_LASER_CONTROL_FP)(const UINT Ctrl, const UINT Value, const UINT Mode, const UINT MinValue, const UINT MaxValue);
extern SET_AUTO_LASER_CONTROL_FP set_auto_laser_control;
typedef UINT (__stdcall *SET_AUTO_LASER_PARAMS_FP)(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern SET_AUTO_LASER_PARAMS_FP set_auto_laser_params;
typedef LONG (__stdcall *LOAD_AUTO_LASER_CONTROL_FP)(const char* Name, const UINT No);
extern LOAD_AUTO_LASER_CONTROL_FP load_auto_laser_control;
typedef LONG (__stdcall *LOAD_POSITION_CONTROL_FP)(const char* Name, const UINT No);
extern LOAD_POSITION_CONTROL_FP load_position_control;
typedef UINT (__stdcall *LOAD_POSITION_CONTROL_2D_CTRL_FP)(const char* Name);
extern LOAD_POSITION_CONTROL_2D_CTRL_FP load_position_control_2d_ctrl;
typedef void (__stdcall *SET_DEFAULT_PIXEL_FP)(const UINT PulseLength);
extern SET_DEFAULT_PIXEL_FP set_default_pixel;
typedef void (__stdcall *GET_STANDBY_FP)(UINT* HalfPeriod, UINT* PulseLength);
extern GET_STANDBY_FP get_standby;
typedef void (__stdcall *SET_PULSE_PICKING_FP)(const UINT No);
extern SET_PULSE_PICKING_FP set_pulse_picking;
typedef void (__stdcall *SET_PULSE_PICKING_LENGTH_FP)(const UINT Length);
extern SET_PULSE_PICKING_LENGTH_FP set_pulse_picking_length;
typedef void (__stdcall *CONFIG_LASER_SIGNALS_FP)(const UINT Config);
extern CONFIG_LASER_SIGNALS_FP config_laser_signals;
typedef void (__stdcall *SPOT_DISTANCE_CTRL_FP)(const double Dist);
extern SPOT_DISTANCE_CTRL_FP spot_distance_ctrl;
typedef void (__stdcall *SET_LASER_PULSE_FORM_FP)(const UINT Mode, const UINT Length);
extern SET_LASER_PULSE_FORM_FP set_laser_pulse_form;
typedef void (__stdcall *SET_LASER_PULSE_SYNC_FP)(const UINT Mode, const UINT Delay);
extern SET_LASER_PULSE_SYNC_FP set_laser_pulse_sync;
typedef void (__stdcall *SET_CONTROLPREVIEW_COMPENSATION_CTRL_FP)(const UINT ControlPreview, const UINT Mode);
extern SET_CONTROLPREVIEW_COMPENSATION_CTRL_FP set_controlpreview_compensation_ctrl;
typedef void (__stdcall *SET_LASER_DELAYS_CTRL_FP)(const LONG LaserOnDelay, const UINT LaserOffDelay);
extern SET_LASER_DELAYS_CTRL_FP set_laser_delays_ctrl;
typedef void (__stdcall *N_SET_EXT_START_DELAY_FP)(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
extern N_SET_EXT_START_DELAY_FP n_set_ext_start_delay;
typedef void (__stdcall *N_SET_ROT_CENTER_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_SET_ROT_CENTER_FP n_set_rot_center;
typedef void (__stdcall *N_SIMULATE_ENCODER_FP)(const UINT CardNo, const UINT EncoderNo);
extern N_SIMULATE_ENCODER_FP n_simulate_encoder;
typedef UINT (__stdcall *N_GET_MARKING_INFO_FP)(const UINT CardNo);
extern N_GET_MARKING_INFO_FP n_get_marking_info;
typedef void (__stdcall *N_SET_ENCODER_SPEED_CTRL_FP)(const UINT CardNo, const UINT EncoderNo, const double Speed, const double Smooth);
extern N_SET_ENCODER_SPEED_CTRL_FP n_set_encoder_speed_ctrl;
typedef void (__stdcall *N_SET_MCBSP_X_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_MCBSP_X_FP n_set_mcbsp_x;
typedef void (__stdcall *N_SET_MCBSP_Y_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_MCBSP_Y_FP n_set_mcbsp_y;
typedef void (__stdcall *N_SET_MCBSP_ROT_FP)(const UINT CardNo, const double Resolution);
extern N_SET_MCBSP_ROT_FP n_set_mcbsp_rot;
typedef void (__stdcall *N_SET_MCBSP_MATRIX_FP)(const UINT CardNo);
extern N_SET_MCBSP_MATRIX_FP n_set_mcbsp_matrix;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_X_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_MCBSP_GLOBAL_X_FP n_set_mcbsp_global_x;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_Y_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_MCBSP_GLOBAL_Y_FP n_set_mcbsp_global_y;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_ROT_FP)(const UINT CardNo, const double Resolution);
extern N_SET_MCBSP_GLOBAL_ROT_FP n_set_mcbsp_global_rot;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_MATRIX_FP)(const UINT CardNo);
extern N_SET_MCBSP_GLOBAL_MATRIX_FP n_set_mcbsp_global_matrix;
typedef void (__stdcall *N_SET_MCBSP_IN_FP)(const UINT CardNo, const UINT Mode, const double Scale);
extern N_SET_MCBSP_IN_FP n_set_mcbsp_in;
typedef void (__stdcall *N_SET_MULTI_MCBSP_IN_FP)(const UINT CardNo, const UINT Ctrl, const UINT P, const UINT Mode);
extern N_SET_MULTI_MCBSP_IN_FP n_set_multi_mcbsp_in;
typedef void (__stdcall *N_SET_FLY_TRACKING_ERROR_FP)(const UINT CardNo, const UINT TrackingErrorX, const UINT TrackingErrorY);
extern N_SET_FLY_TRACKING_ERROR_FP n_set_fly_tracking_error;
typedef LONG (__stdcall *N_LOAD_FLY_2D_TABLE_FP)(const UINT CardNo, const char* Name, const UINT No);
extern N_LOAD_FLY_2D_TABLE_FP n_load_fly_2d_table;
typedef void (__stdcall *N_INIT_FLY_2D_FP)(const UINT CardNo, const LONG OffsetX, const LONG OffsetY, const UINT No);
extern N_INIT_FLY_2D_FP n_init_fly_2d;
typedef void (__stdcall *N_GET_FLY_2D_OFFSET_FP)(const UINT CardNo, LONG* OffsetX, LONG* OffsetY);
extern N_GET_FLY_2D_OFFSET_FP n_get_fly_2d_offset;
typedef void (__stdcall *N_GET_ENCODER_FP)(const UINT CardNo, LONG* Encoder0, LONG* Encoder1);
extern N_GET_ENCODER_FP n_get_encoder;
typedef void (__stdcall *N_READ_ENCODER_FP)(const UINT CardNo, LONG* Encoder0_1, LONG* Encoder1_1, LONG* Encoder0_2, LONG* Encoder1_2);
extern N_READ_ENCODER_FP n_read_encoder;
typedef LONG (__stdcall *N_GET_MCBSP_FP)(const UINT CardNo);
extern N_GET_MCBSP_FP n_get_mcbsp;
typedef LONG (__stdcall *N_READ_MCBSP_FP)(const UINT CardNo, const UINT No);
extern N_READ_MCBSP_FP n_read_mcbsp;
typedef LONG (__stdcall *N_READ_MULTI_MCBSP_FP)(const UINT CardNo, const UINT No);
extern N_READ_MULTI_MCBSP_FP n_read_multi_mcbsp;
typedef void (__stdcall *N_CLEAR_FLY_OVERFLOW_CTRL_FP)(const UINT CardNo, const UINT Mode);
extern N_CLEAR_FLY_OVERFLOW_CTRL_FP n_clear_fly_overflow_ctrl;
typedef void (__stdcall *N_SET_ENCODER_FILTER_CTRL_FP)(const UINT CardNo, const UINT Length, const UINT Mode);
extern N_SET_ENCODER_FILTER_CTRL_FP n_set_encoder_filter_ctrl;
typedef void (__stdcall *SET_EXT_START_DELAY_FP)(const LONG Delay, const UINT EncoderNo);
extern SET_EXT_START_DELAY_FP set_ext_start_delay;
typedef void (__stdcall *SET_ROT_CENTER_FP)(const LONG X, const LONG Y);
extern SET_ROT_CENTER_FP set_rot_center;
typedef void (__stdcall *SIMULATE_ENCODER_FP)(const UINT EncoderNo);
extern SIMULATE_ENCODER_FP simulate_encoder;
typedef UINT (__stdcall *GET_MARKING_INFO_FP)(void);
extern GET_MARKING_INFO_FP get_marking_info;
typedef void (__stdcall *SET_ENCODER_SPEED_CTRL_FP)(const UINT EncoderNo, const double Speed, const double Smooth);
extern SET_ENCODER_SPEED_CTRL_FP set_encoder_speed_ctrl;
typedef void (__stdcall *SET_MCBSP_X_FP)(const double ScaleX);
extern SET_MCBSP_X_FP set_mcbsp_x;
typedef void (__stdcall *SET_MCBSP_Y_FP)(const double ScaleY);
extern SET_MCBSP_Y_FP set_mcbsp_y;
typedef void (__stdcall *SET_MCBSP_ROT_FP)(const double Resolution);
extern SET_MCBSP_ROT_FP set_mcbsp_rot;
typedef void (__stdcall *SET_MCBSP_MATRIX_FP)(void);
extern SET_MCBSP_MATRIX_FP set_mcbsp_matrix;
typedef void (__stdcall *SET_MCBSP_GLOBAL_X_FP)(const double ScaleX);
extern SET_MCBSP_GLOBAL_X_FP set_mcbsp_global_x;
typedef void (__stdcall *SET_MCBSP_GLOBAL_Y_FP)(const double ScaleY);
extern SET_MCBSP_GLOBAL_Y_FP set_mcbsp_global_y;
typedef void (__stdcall *SET_MCBSP_GLOBAL_ROT_FP)(const double Resolution);
extern SET_MCBSP_GLOBAL_ROT_FP set_mcbsp_global_rot;
typedef void (__stdcall *SET_MCBSP_GLOBAL_MATRIX_FP)(void);
extern SET_MCBSP_GLOBAL_MATRIX_FP set_mcbsp_global_matrix;
typedef void (__stdcall *SET_MCBSP_IN_FP)(const UINT Mode, const double Scale);
extern SET_MCBSP_IN_FP set_mcbsp_in;
typedef void (__stdcall *SET_MULTI_MCBSP_IN_FP)(const UINT Ctrl, const UINT P, const UINT Mode);
extern SET_MULTI_MCBSP_IN_FP set_multi_mcbsp_in;
typedef void (__stdcall *SET_FLY_TRACKING_ERROR_FP)(const UINT TrackingErrorX, const UINT TrackingErrorY);
extern SET_FLY_TRACKING_ERROR_FP set_fly_tracking_error;
typedef LONG (__stdcall *LOAD_FLY_2D_TABLE_FP)(const char* Name, const UINT No);
extern LOAD_FLY_2D_TABLE_FP load_fly_2d_table;
typedef void (__stdcall *INIT_FLY_2D_FP)(const LONG OffsetX, const LONG OffsetY, const UINT No);
extern INIT_FLY_2D_FP init_fly_2d;
typedef void (__stdcall *GET_FLY_2D_OFFSET_FP)(LONG* OffsetX, LONG* OffsetY);
extern GET_FLY_2D_OFFSET_FP get_fly_2d_offset;
typedef void (__stdcall *GET_ENCODER_FP)(LONG* Encoder0, LONG* Encoder1);
extern GET_ENCODER_FP get_encoder;
typedef void (__stdcall *READ_ENCODER_FP)(LONG* Encoder0_1, LONG* Encoder1_1, LONG* Encoder0_2, LONG* Encoder1_2);
extern READ_ENCODER_FP read_encoder;
typedef LONG (__stdcall *GET_MCBSP_FP)(void);
extern GET_MCBSP_FP get_mcbsp;
typedef LONG (__stdcall *READ_MCBSP_FP)(const UINT No);
extern READ_MCBSP_FP read_mcbsp;
typedef LONG (__stdcall *READ_MULTI_MCBSP_FP)(const UINT No);
extern READ_MULTI_MCBSP_FP read_multi_mcbsp;
typedef void (__stdcall *CLEAR_FLY_OVERFLOW_CTRL_FP)(const UINT Mode);
extern CLEAR_FLY_OVERFLOW_CTRL_FP clear_fly_overflow_ctrl;
typedef void (__stdcall *SET_ENCODER_FILTER_CTRL_FP)(const UINT Length, const UINT Mode);
extern SET_ENCODER_FILTER_CTRL_FP set_encoder_filter_ctrl;
typedef double (__stdcall *N_GET_TIME_FP)(const UINT CardNo);
extern N_GET_TIME_FP n_get_time;
typedef double (__stdcall *N_GET_LAP_TIME_FP)(const UINT CardNo);
extern N_GET_LAP_TIME_FP n_get_lap_time;
typedef void (__stdcall *N_MEASUREMENT_STATUS_FP)(const UINT CardNo, UINT* Busy, UINT* Pos);
extern N_MEASUREMENT_STATUS_FP n_measurement_status;
typedef void (__stdcall *N_GET_WAVEFORM_OFFSET_FP)(const UINT CardNo, const UINT Channel, const UINT Offset, const UINT Number, const ULONG_PTR Ptr);
extern N_GET_WAVEFORM_OFFSET_FP n_get_waveform_offset;
typedef void (__stdcall *N_GET_WAVEFORM_FP)(const UINT CardNo, const UINT Channel, const UINT Number, const ULONG_PTR Ptr);
extern N_GET_WAVEFORM_FP n_get_waveform;
typedef void (__stdcall *N_BOUNCE_SUPP_FP)(const UINT CardNo, const UINT Length);
extern N_BOUNCE_SUPP_FP n_bounce_supp;
typedef void (__stdcall *N_HOME_POSITION_4_FP)(const UINT CardNo, const LONG X0Home, const LONG X1Home, const LONG X2Home, const LONG X3Home);
extern N_HOME_POSITION_4_FP n_home_position_4;
typedef void (__stdcall *N_GET_HOME_POSITION_4_FP)(const UINT CardNo, LONG* X0Home, LONG* X1Home, LONG* X2Home, LONG* X3Home);
extern N_GET_HOME_POSITION_4_FP n_get_home_position_4;
typedef void (__stdcall *N_SET_HOME_4_RETURN_TIME_FP)(const UINT CardNo, const UINT Time);
extern N_SET_HOME_4_RETURN_TIME_FP n_set_home_4_return_time;
typedef UINT (__stdcall *N_GET_HOME_4_RETURN_TIME_FP)(const UINT CardNo);
extern N_GET_HOME_4_RETURN_TIME_FP n_get_home_4_return_time;
typedef void (__stdcall *N_HOME_POSITION_XYZ_FP)(const UINT CardNo, const LONG XHome, const LONG YHome, const LONG ZHome);
extern N_HOME_POSITION_XYZ_FP n_home_position_xyz;
typedef void (__stdcall *N_HOME_POSITION_FP)(const UINT CardNo, const LONG XHome, const LONG YHome);
extern N_HOME_POSITION_FP n_home_position;
typedef UINT (__stdcall *N_UART_CONFIG_FP)(const UINT CardNo, const UINT BaudRate);
extern N_UART_CONFIG_FP n_uart_config;
typedef void (__stdcall *N_RS232_CONFIG_FP)(const UINT CardNo, const UINT BaudRate);
extern N_RS232_CONFIG_FP n_rs232_config;
typedef void (__stdcall *N_RS232_WRITE_DATA_FP)(const UINT CardNo, const UINT Data);
extern N_RS232_WRITE_DATA_FP n_rs232_write_data;
typedef void (__stdcall *N_RS232_WRITE_TEXT_FP)(const UINT CardNo, const char* pData);
extern N_RS232_WRITE_TEXT_FP n_rs232_write_text;
typedef UINT (__stdcall *N_RS232_READ_DATA_FP)(const UINT CardNo);
extern N_RS232_READ_DATA_FP n_rs232_read_data;
typedef UINT (__stdcall *N_SET_MCBSP_FREQ_FP)(const UINT CardNo, const UINT Freq);
extern N_SET_MCBSP_FREQ_FP n_set_mcbsp_freq;
typedef void (__stdcall *N_MCBSP_INIT_FP)(const UINT CardNo, const UINT XDelay, const UINT RDelay);
extern N_MCBSP_INIT_FP n_mcbsp_init;
typedef void (__stdcall *N_MCBSP_INIT_SPI_FP)(const UINT CardNo, const UINT ClockLevel, const UINT ClockDelay);
extern N_MCBSP_INIT_SPI_FP n_mcbsp_init_spi;
typedef UINT (__stdcall *N_GET_OVERRUN_FP)(const UINT CardNo);
extern N_GET_OVERRUN_FP n_get_overrun;
typedef UINT (__stdcall *N_GET_MASTER_SLAVE_FP)(const UINT CardNo);
extern N_GET_MASTER_SLAVE_FP n_get_master_slave;
typedef void (__stdcall *N_GET_TRANSFORM_FP)(const UINT CardNo, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
extern N_GET_TRANSFORM_FP n_get_transform;
typedef void (__stdcall *N_GET_TRANSFORM_OFFSET_FP)(const UINT CardNo, const UINT Channel1, const UINT Channel2, const UINT Offset, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
extern N_GET_TRANSFORM_OFFSET_FP n_get_transform_offset;
typedef void (__stdcall *N_STOP_TRIGGER_FP)(const UINT CardNo);
extern N_STOP_TRIGGER_FP n_stop_trigger;
typedef void (__stdcall *N_MOVE_TO_FP)(const UINT CardNo, const UINT Pos);
extern N_MOVE_TO_FP n_move_to;
typedef void (__stdcall *N_SET_ENDURING_WOBBEL_FP)(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern N_SET_ENDURING_WOBBEL_FP n_set_enduring_wobbel;
typedef void (__stdcall *N_SET_ENDURING_WOBBEL_2_FP)(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern N_SET_ENDURING_WOBBEL_2_FP n_set_enduring_wobbel_2;
typedef void (__stdcall *N_SET_ENDURING_WOBBEL_3_FP)(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern N_SET_ENDURING_WOBBEL_3_FP n_set_enduring_wobbel_3;
typedef void (__stdcall *N_SET_ENDURING_WOBBEL_4_FP)(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern N_SET_ENDURING_WOBBEL_4_FP n_set_enduring_wobbel_4;
typedef void (__stdcall *N_SET_ENDURING_WOBBEL_CTRL_FP)(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ, const UINT Mode, const UINT Ctrl);
extern N_SET_ENDURING_WOBBEL_CTRL_FP n_set_enduring_wobbel_ctrl;
typedef UINT (__stdcall *N_CHECK_ENDURING_WOBBEL_FP)(const UINT CardNo);
extern N_CHECK_ENDURING_WOBBEL_FP n_check_enduring_wobbel;
typedef void (__stdcall *N_SET_FREE_VARIABLE_FP)(const UINT CardNo, const UINT VarNo, const UINT Value);
extern N_SET_FREE_VARIABLE_FP n_set_free_variable;
typedef UINT (__stdcall *N_GET_FREE_VARIABLE_FP)(const UINT CardNo, const UINT VarNo);
extern N_GET_FREE_VARIABLE_FP n_get_free_variable;
typedef void (__stdcall *N_SET_MCBSP_OUT_PTR_FP)(const UINT CardNo, const UINT Number, const ULONG_PTR SignalPtr);
extern N_SET_MCBSP_OUT_PTR_FP n_set_mcbsp_out_ptr;
typedef void (__stdcall *N_SET_MCBSP_OUT_OIE_CTRL_FP)(const UINT CardNo, const UINT Signal1, const UINT Signal2);
extern N_SET_MCBSP_OUT_OIE_CTRL_FP n_set_mcbsp_out_oie_ctrl;
typedef void (__stdcall *N_PERIODIC_TOGGLE_FP)(const UINT CardNo, const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
extern N_PERIODIC_TOGGLE_FP n_periodic_toggle;
typedef UINT (__stdcall *N_MULTI_AXIS_SET_CONFIG_CTRL_FP)(const UINT CardNo, const UINT Mode, const UINT BlockSize, const UINT NumAxes, const UINT StopOnFrameError, const UINT StopOnStageError);
extern N_MULTI_AXIS_SET_CONFIG_CTRL_FP n_multi_axis_set_config_ctrl;
typedef void (__stdcall *N_MULTI_AXIS_GET_CONFIG_CTRL_FP)(const UINT CardNo, UINT* Mode, UINT* BlockSize, UINT* NumAxes, UINT* StopOnFrameError, UINT* StopOnStageError);
extern N_MULTI_AXIS_GET_CONFIG_CTRL_FP n_multi_axis_get_config_ctrl;
typedef UINT (__stdcall *N_MULTI_AXIS_GET_ERROR_CTRL_FP)(const UINT CardNo);
extern N_MULTI_AXIS_GET_ERROR_CTRL_FP n_multi_axis_get_error_ctrl;
typedef UINT (__stdcall *N_MULTI_AXIS_INIT_CTRL_FP)(const UINT CardNo, const ULONG_PTR StageAxesPtr);
extern N_MULTI_AXIS_INIT_CTRL_FP n_multi_axis_init_ctrl;
typedef void (__stdcall *N_MULTI_AXIS_GET_VALUES_CTRL_FP)(const UINT CardNo, const ULONG_PTR StageAxesPtr, const ULONG_PTR FlagsPtr);
extern N_MULTI_AXIS_GET_VALUES_CTRL_FP n_multi_axis_get_values_ctrl;
typedef double (__stdcall *N_GET_TEMPERATURE_FP)(const UINT CardNo);
extern N_GET_TEMPERATURE_FP n_get_temperature;
typedef UINT (__stdcall *N_GET_EXTENDED_HEAD_STATUS_VALUE_CTRL_FP)(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Value);
extern N_GET_EXTENDED_HEAD_STATUS_VALUE_CTRL_FP n_get_extended_head_status_value_ctrl;
typedef void (__stdcall *N_GET_EXTENDED_HEAD_STATUS_BLOCK_CTRL_FP)(const UINT CardNo, const UINT Head, const UINT Axis, const ULONG_PTR Ptr);
extern N_GET_EXTENDED_HEAD_STATUS_BLOCK_CTRL_FP n_get_extended_head_status_block_ctrl;
typedef UINT (__stdcall *N_GET_RCM_VALUE_CTRL_FP)(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Value);
extern N_GET_RCM_VALUE_CTRL_FP n_get_rcm_value_ctrl;
typedef void (__stdcall *N_MARKING_INFO_ACK_CTRL_FP)(const UINT CardNo, const UINT AckMask);
extern N_MARKING_INFO_ACK_CTRL_FP n_marking_info_ack_ctrl;
typedef void (__stdcall *N_SET_SL2_100_ERROR_TOLERANCE_CTRL_FP)(const UINT CardNo, const UINT Tol_10us);
extern N_SET_SL2_100_ERROR_TOLERANCE_CTRL_FP n_set_sl2_100_error_tolerance_ctrl;
typedef UINT (__stdcall *N_GET_SL2_100_ERROR_TOLERANCE_CTRL_FP)(const UINT CardNo);
extern N_GET_SL2_100_ERROR_TOLERANCE_CTRL_FP n_get_sl2_100_error_tolerance_ctrl;
typedef void (__stdcall *N_SET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP)(const UINT CardNo, const bool Enable);
extern N_SET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP n_set_sl2_100_error_tolerance_enable_ctrl;
typedef bool (__stdcall *N_GET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP)(const UINT CardNo);
extern N_GET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP n_get_sl2_100_error_tolerance_enable_ctrl;
typedef void (__stdcall *N_SET_EXPLICIT_ACK_MODE_CTRL_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_EXPLICIT_ACK_MODE_CTRL_FP n_set_explicit_ack_mode_ctrl;
typedef void (__stdcall *N_STARTSTOP_INFO_ACK_CTRL_FP)(const UINT CardNo, const UINT AckMask);
extern N_STARTSTOP_INFO_ACK_CTRL_FP n_startstop_info_ack_ctrl;
typedef double (__stdcall *GET_TIME_FP)(void);
extern GET_TIME_FP get_time;
typedef double (__stdcall *GET_LAP_TIME_FP)(void);
extern GET_LAP_TIME_FP get_lap_time;
typedef void (__stdcall *MEASUREMENT_STATUS_FP)(UINT* Busy, UINT* Pos);
extern MEASUREMENT_STATUS_FP measurement_status;
typedef void (__stdcall *GET_WAVEFORM_OFFSET_FP)(const UINT Channel, const UINT Offset, const UINT Number, const ULONG_PTR Ptr);
extern GET_WAVEFORM_OFFSET_FP get_waveform_offset;
typedef void (__stdcall *GET_WAVEFORM_FP)(const UINT Channel, const UINT Number, const ULONG_PTR Ptr);
extern GET_WAVEFORM_FP get_waveform;
typedef void (__stdcall *BOUNCE_SUPP_FP)(const UINT Length);
extern BOUNCE_SUPP_FP bounce_supp;
typedef void (__stdcall *HOME_POSITION_4_FP)(const LONG X0Home, const LONG X1Home, const LONG X2Home, const LONG X3Home);
extern HOME_POSITION_4_FP home_position_4;
typedef void (__stdcall *GET_HOME_POSITION_4_FP)(LONG* X0Home, LONG* X1Home, LONG* X2Home, LONG* X3Home);
extern GET_HOME_POSITION_4_FP get_home_position_4;
typedef void (__stdcall *SET_HOME_4_RETURN_TIME_FP)(const UINT Time);
extern SET_HOME_4_RETURN_TIME_FP set_home_4_return_time;
typedef UINT (__stdcall *GET_HOME_4_RETURN_TIME_FP)(void);
extern GET_HOME_4_RETURN_TIME_FP get_home_4_return_time;
typedef void (__stdcall *HOME_POSITION_XYZ_FP)(const LONG XHome, const LONG YHome, const LONG ZHome);
extern HOME_POSITION_XYZ_FP home_position_xyz;
typedef void (__stdcall *HOME_POSITION_FP)(const LONG XHome, const LONG YHome);
extern HOME_POSITION_FP home_position;
typedef UINT (__stdcall *UART_CONFIG_FP)(const UINT BaudRate);
extern UART_CONFIG_FP uart_config;
typedef void (__stdcall *RS232_CONFIG_FP)(const UINT BaudRate);
extern RS232_CONFIG_FP rs232_config;
typedef void (__stdcall *RS232_WRITE_DATA_FP)(const UINT Data);
extern RS232_WRITE_DATA_FP rs232_write_data;
typedef void (__stdcall *RS232_WRITE_TEXT_FP)(const char* pData);
extern RS232_WRITE_TEXT_FP rs232_write_text;
typedef UINT (__stdcall *RS232_READ_DATA_FP)(void);
extern RS232_READ_DATA_FP rs232_read_data;
typedef UINT (__stdcall *SET_MCBSP_FREQ_FP)(const UINT Freq);
extern SET_MCBSP_FREQ_FP set_mcbsp_freq;
typedef void (__stdcall *MCBSP_INIT_FP)(const UINT XDelay, const UINT RDelay);
extern MCBSP_INIT_FP mcbsp_init;
typedef void (__stdcall *MCBSP_INIT_SPI_FP)(const UINT ClockLevel, const UINT ClockDelay);
extern MCBSP_INIT_SPI_FP mcbsp_init_spi;
typedef UINT (__stdcall *GET_OVERRUN_FP)(void);
extern GET_OVERRUN_FP get_overrun;
typedef UINT (__stdcall *GET_MASTER_SLAVE_FP)(void);
extern GET_MASTER_SLAVE_FP get_master_slave;
typedef void (__stdcall *GET_TRANSFORM_FP)(const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
extern GET_TRANSFORM_FP get_transform;
typedef void (__stdcall *GET_TRANSFORM_OFFSET_FP)(const UINT Channel1, const UINT Channel2, const UINT Offset, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
extern GET_TRANSFORM_OFFSET_FP get_transform_offset;
typedef void (__stdcall *STOP_TRIGGER_FP)(void);
extern STOP_TRIGGER_FP stop_trigger;
typedef void (__stdcall *MOVE_TO_FP)(const UINT Pos);
extern MOVE_TO_FP move_to;
typedef void (__stdcall *SET_ENDURING_WOBBEL_FP)(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern SET_ENDURING_WOBBEL_FP set_enduring_wobbel;
typedef void (__stdcall *SET_ENDURING_WOBBEL_2_FP)(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern SET_ENDURING_WOBBEL_2_FP set_enduring_wobbel_2;
typedef void (__stdcall *SET_ENDURING_WOBBEL_3_FP)(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern SET_ENDURING_WOBBEL_3_FP set_enduring_wobbel_3;
typedef void (__stdcall *SET_ENDURING_WOBBEL_4_FP)(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
extern SET_ENDURING_WOBBEL_4_FP set_enduring_wobbel_4;
typedef void (__stdcall *SET_ENDURING_WOBBEL_CTRL_FP)(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ, const UINT Mode, const UINT Ctrl);
extern SET_ENDURING_WOBBEL_CTRL_FP set_enduring_wobbel_ctrl;
typedef UINT (__stdcall *CHECK_ENDURING_WOBBEL_FP)(void);
extern CHECK_ENDURING_WOBBEL_FP check_enduring_wobbel;
typedef void (__stdcall *SET_FREE_VARIABLE_FP)(const UINT VarNo, const UINT Value);
extern SET_FREE_VARIABLE_FP set_free_variable;
typedef UINT (__stdcall *GET_FREE_VARIABLE_FP)(const UINT VarNo);
extern GET_FREE_VARIABLE_FP get_free_variable;
typedef void (__stdcall *SET_MCBSP_OUT_PTR_FP)(const UINT Number, const ULONG_PTR SignalPtr);
extern SET_MCBSP_OUT_PTR_FP set_mcbsp_out_ptr;
typedef void (__stdcall *SET_MCBSP_OUT_OIE_CTRL_FP)(const UINT Signal1, const UINT Signal2);
extern SET_MCBSP_OUT_OIE_CTRL_FP set_mcbsp_out_oie_ctrl;
typedef void (__stdcall *PERIODIC_TOGGLE_FP)(const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
extern PERIODIC_TOGGLE_FP periodic_toggle;
typedef UINT (__stdcall *MULTI_AXIS_SET_CONFIG_CTRL_FP)(const UINT Mode, const UINT BlockSize, const UINT NumAxes, const UINT StopOnFrameError, const UINT StopOnStageError);
extern MULTI_AXIS_SET_CONFIG_CTRL_FP multi_axis_set_config_ctrl;
typedef void (__stdcall *MULTI_AXIS_GET_CONFIG_CTRL_FP)(UINT* Mode, UINT* BlockSize, UINT* NumAxes, UINT* StopOnFrameError, UINT* StopOnStageError);
extern MULTI_AXIS_GET_CONFIG_CTRL_FP multi_axis_get_config_ctrl;
typedef UINT (__stdcall *MULTI_AXIS_GET_ERROR_CTRL_FP)(void);
extern MULTI_AXIS_GET_ERROR_CTRL_FP multi_axis_get_error_ctrl;
typedef UINT (__stdcall *MULTI_AXIS_INIT_CTRL_FP)(const ULONG_PTR StageAxesPtr);
extern MULTI_AXIS_INIT_CTRL_FP multi_axis_init_ctrl;
typedef void (__stdcall *MULTI_AXIS_GET_VALUES_CTRL_FP)(const ULONG_PTR StageAxesPtr, const ULONG_PTR FlagsPtr);
extern MULTI_AXIS_GET_VALUES_CTRL_FP multi_axis_get_values_ctrl;
typedef double (__stdcall *GET_TEMPERATURE_FP)(void);
extern GET_TEMPERATURE_FP get_temperature;
typedef UINT (__stdcall *GET_EXTENDED_HEAD_STATUS_VALUE_CTRL_FP)(const UINT Head, const UINT Axis, const UINT Value);
extern GET_EXTENDED_HEAD_STATUS_VALUE_CTRL_FP get_extended_head_status_value_ctrl;
typedef void (__stdcall *GET_EXTENDED_HEAD_STATUS_BLOCK_CTRL_FP)(const UINT Head, const UINT Axis, const ULONG_PTR Ptr);
extern GET_EXTENDED_HEAD_STATUS_BLOCK_CTRL_FP get_extended_head_status_block_ctrl;
typedef UINT (__stdcall *GET_RCM_VALUE_CTRL_FP)(const UINT Head, const UINT Axis, const UINT Value);
extern GET_RCM_VALUE_CTRL_FP get_rcm_value_ctrl;
typedef void (__stdcall *MARKING_INFO_ACK_CTRL_FP)(const UINT AckMask);
extern MARKING_INFO_ACK_CTRL_FP marking_info_ack_ctrl;
typedef void (__stdcall *SET_SL2_100_ERROR_TOLERANCE_CTRL_FP)(const UINT Tol_10us);
extern SET_SL2_100_ERROR_TOLERANCE_CTRL_FP set_sl2_100_error_tolerance_ctrl;
typedef UINT (__stdcall *GET_SL2_100_ERROR_TOLERANCE_CTRL_FP)(void);
extern GET_SL2_100_ERROR_TOLERANCE_CTRL_FP get_sl2_100_error_tolerance_ctrl;
typedef void (__stdcall *SET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP)(const bool Enable);
extern SET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP set_sl2_100_error_tolerance_enable_ctrl;
typedef bool (__stdcall *GET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP)(void);
extern GET_SL2_100_ERROR_TOLERANCE_ENABLE_CTRL_FP get_sl2_100_error_tolerance_enable_ctrl;
typedef void (__stdcall *SET_EXPLICIT_ACK_MODE_CTRL_FP)(const UINT Mode);
extern SET_EXPLICIT_ACK_MODE_CTRL_FP set_explicit_ack_mode_ctrl;
typedef void (__stdcall *STARTSTOP_INFO_ACK_CTRL_FP)(const UINT AckMask);
extern STARTSTOP_INFO_ACK_CTRL_FP startstop_info_ack_ctrl;
typedef void (__stdcall *N_SET_DEFOCUS_FP)(const UINT CardNo, const LONG Shift);
extern N_SET_DEFOCUS_FP n_set_defocus;
typedef void (__stdcall *N_SET_DEFOCUS_OFFSET_FP)(const UINT CardNo, const LONG Shift);
extern N_SET_DEFOCUS_OFFSET_FP n_set_defocus_offset;
typedef void (__stdcall *N_GOTO_XYZ_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
extern N_GOTO_XYZ_FP n_goto_xyz;
typedef void (__stdcall *N_SET_ZOOM_FP)(const UINT CardNo, const UINT Zoom);
extern N_SET_ZOOM_FP n_set_zoom;
typedef void (__stdcall *N_GOTO_XY_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_GOTO_XY_FP n_goto_xy;
typedef LONG (__stdcall *N_GET_Z_DISTANCE_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
extern N_GET_Z_DISTANCE_FP n_get_z_distance;
typedef void (__stdcall *SET_DEFOCUS_FP)(const LONG Shift);
extern SET_DEFOCUS_FP set_defocus;
typedef void (__stdcall *SET_DEFOCUS_OFFSET_FP)(const LONG Shift);
extern SET_DEFOCUS_OFFSET_FP set_defocus_offset;
typedef void (__stdcall *GOTO_XYZ_FP)(const LONG X, const LONG Y, const LONG Z);
extern GOTO_XYZ_FP goto_xyz;
typedef void (__stdcall *GOTO_XY_FP)(const LONG X, const LONG Y);
extern GOTO_XY_FP goto_xy;
typedef void (__stdcall *SET_ZOOM_FP)(const UINT Zoom);
extern SET_ZOOM_FP set_zoom;
typedef LONG (__stdcall *GET_Z_DISTANCE_FP)(const LONG X, const LONG Y, const LONG Z);
extern GET_Z_DISTANCE_FP get_z_distance;
typedef void (__stdcall *N_SET_OFFSET_XYZ_FP)(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
extern N_SET_OFFSET_XYZ_FP n_set_offset_xyz;
typedef void (__stdcall *N_SET_OFFSET_FP)(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
extern N_SET_OFFSET_FP n_set_offset;
typedef void (__stdcall *N_SET_MATRIX_FP)(const UINT CardNo, const UINT HeadNo, const double M11, const double M12, const double M21, const double M22, const UINT at_once);
extern N_SET_MATRIX_FP n_set_matrix;
typedef void (__stdcall *N_SET_ANGLE_FP)(const UINT CardNo, const UINT HeadNo, const double Angle, const UINT at_once);
extern N_SET_ANGLE_FP n_set_angle;
typedef void (__stdcall *N_SET_SCALE_FP)(const UINT CardNo, const UINT HeadNo, const double Scale, const UINT at_once);
extern N_SET_SCALE_FP n_set_scale;
typedef void (__stdcall *N_APPLY_MCBSP_FP)(const UINT CardNo, const UINT HeadNo, const UINT at_once);
extern N_APPLY_MCBSP_FP n_apply_mcbsp;
typedef UINT (__stdcall *N_UPLOAD_TRANSFORM_FP)(const UINT CardNo, const UINT HeadNo, const ULONG_PTR Ptr);
extern N_UPLOAD_TRANSFORM_FP n_upload_transform;
typedef void (__stdcall *SET_OFFSET_XYZ_FP)(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
extern SET_OFFSET_XYZ_FP set_offset_xyz;
typedef void (__stdcall *SET_OFFSET_FP)(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
extern SET_OFFSET_FP set_offset;
typedef void (__stdcall *SET_MATRIX_FP)(const UINT HeadNo, const double M11, const double M12, const double M21, const double M22, const UINT at_once);
extern SET_MATRIX_FP set_matrix;
typedef void (__stdcall *SET_ANGLE_FP)(const UINT HeadNo, const double Angle, const UINT at_once);
extern SET_ANGLE_FP set_angle;
typedef void (__stdcall *SET_SCALE_FP)(const UINT HeadNo, const double Scale, const UINT at_once);
extern SET_SCALE_FP set_scale;
typedef void (__stdcall *APPLY_MCBSP_FP)(const UINT HeadNo, const UINT at_once);
extern APPLY_MCBSP_FP apply_mcbsp;
typedef UINT (__stdcall *UPLOAD_TRANSFORM_FP)(const UINT HeadNo, const ULONG_PTR Ptr);
extern UPLOAD_TRANSFORM_FP upload_transform;
typedef void (__stdcall *N_SET_DELAY_MODE_FP)(const UINT CardNo, const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
extern N_SET_DELAY_MODE_FP n_set_delay_mode;
typedef void (__stdcall *N_SET_JUMP_SPEED_CTRL_FP)(const UINT CardNo, const double Speed);
extern N_SET_JUMP_SPEED_CTRL_FP n_set_jump_speed_ctrl;
typedef void (__stdcall *N_SET_MARK_SPEED_CTRL_FP)(const UINT CardNo, const double Speed);
extern N_SET_MARK_SPEED_CTRL_FP n_set_mark_speed_ctrl;
typedef void (__stdcall *N_SET_SKY_WRITING_PARA_FP)(const UINT CardNo, const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
extern N_SET_SKY_WRITING_PARA_FP n_set_sky_writing_para;
typedef void (__stdcall *N_SET_SKY_WRITING_LIMIT_FP)(const UINT CardNo, const double CosAngle);
extern N_SET_SKY_WRITING_LIMIT_FP n_set_sky_writing_limit;
typedef void (__stdcall *N_SET_SKY_WRITING_MODE_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_SKY_WRITING_MODE_FP n_set_sky_writing_mode;
typedef void (__stdcall *N_SET_SKY_WRITING_MIN_SPEED_CTRL_FP)(const UINT CardNo, const double Speed);
extern N_SET_SKY_WRITING_MIN_SPEED_CTRL_FP n_set_sky_writing_min_speed_ctrl;
typedef void (__stdcall *N_SET_SKY_WRITING_SCALE_CTRL_FP)(const UINT CardNo, const double Scale);
extern N_SET_SKY_WRITING_SCALE_CTRL_FP n_set_sky_writing_scale_ctrl;
typedef LONG (__stdcall *N_LOAD_VARPOLYDELAY_FP)(const UINT CardNo, const char* Name, const UINT No);
extern N_LOAD_VARPOLYDELAY_FP n_load_varpolydelay;
typedef void (__stdcall *N_SET_HI_FP)(const UINT CardNo, const UINT HeadNo, const double GalvoGainX, const double GalvoGainY, const LONG GalvoOffsetX, const LONG GalvoOffsetY);
extern N_SET_HI_FP n_set_hi;
typedef void (__stdcall *N_GET_HI_POS_FP)(const UINT CardNo, const UINT HeadNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
extern N_GET_HI_POS_FP n_get_hi_pos;
typedef UINT (__stdcall *N_AUTO_CAL_FP)(const UINT CardNo, const UINT HeadNo, const UINT Command);
extern N_AUTO_CAL_FP n_auto_cal;
typedef UINT (__stdcall *N_GET_AUTO_CAL_FP)(const UINT CardNo, const UINT HeadNo);
extern N_GET_AUTO_CAL_FP n_get_auto_cal;
typedef UINT (__stdcall *N_WRITE_HI_POS_FP)(const UINT CardNo, const UINT HeadNo, const LONG X1, const LONG X2, const LONG Y1, const LONG Y2);
extern N_WRITE_HI_POS_FP n_write_hi_pos;
typedef void (__stdcall *N_SET_TIMELAG_COMPENSATION_FP)(const UINT CardNo, const UINT HeadNo, const UINT TimeLagXY, const UINT TimeLagZ);
extern N_SET_TIMELAG_COMPENSATION_FP n_set_timelag_compensation;
typedef void (__stdcall *N_SET_SCANNER_DELAYS_CTRL_FP)(const UINT CardNo, const UINT Jump, const UINT Mark, const UINT Polygon);
extern N_SET_SCANNER_DELAYS_CTRL_FP n_set_scanner_delays_ctrl;
typedef void (__stdcall *N_SET_SKY_WRITING_FP)(const UINT CardNo, const double Timelag, const LONG LaserOnShift);
extern N_SET_SKY_WRITING_FP n_set_sky_writing;
typedef void (__stdcall *N_GET_HI_DATA_FP)(const UINT CardNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
extern N_GET_HI_DATA_FP n_get_hi_data;
typedef void (__stdcall *SET_DELAY_MODE_FP)(const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
extern SET_DELAY_MODE_FP set_delay_mode;
typedef void (__stdcall *SET_JUMP_SPEED_CTRL_FP)(const double Speed);
extern SET_JUMP_SPEED_CTRL_FP set_jump_speed_ctrl;
typedef void (__stdcall *SET_MARK_SPEED_CTRL_FP)(const double Speed);
extern SET_MARK_SPEED_CTRL_FP set_mark_speed_ctrl;
typedef void (__stdcall *SET_SKY_WRITING_PARA_FP)(const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
extern SET_SKY_WRITING_PARA_FP set_sky_writing_para;
typedef void (__stdcall *SET_SKY_WRITING_LIMIT_FP)(const double CosAngle);
extern SET_SKY_WRITING_LIMIT_FP set_sky_writing_limit;
typedef void (__stdcall *SET_SKY_WRITING_MODE_FP)(const UINT Mode);
extern SET_SKY_WRITING_MODE_FP set_sky_writing_mode;
typedef void (__stdcall *SET_SKY_WRITING_MIN_SPEED_CTRL_FP)(const double Speed);
extern SET_SKY_WRITING_MIN_SPEED_CTRL_FP set_sky_writing_min_speed_ctrl;
typedef void (__stdcall *SET_SKY_WRITING_SCALE_CTRL_FP)(const double Scale);
extern SET_SKY_WRITING_SCALE_CTRL_FP set_sky_writing_scale_ctrl;
typedef LONG (__stdcall *LOAD_VARPOLYDELAY_FP)(const char* Name, const UINT No);
extern LOAD_VARPOLYDELAY_FP load_varpolydelay;
typedef void (__stdcall *SET_HI_FP)(const UINT HeadNo, const double GalvoGainX, const double GalvoGainY, const LONG GalvoOffsetX, const LONG GalvoOffsetY);
extern SET_HI_FP set_hi;
typedef void (__stdcall *GET_HI_POS_FP)(const UINT HeadNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
extern GET_HI_POS_FP get_hi_pos;
typedef UINT (__stdcall *AUTO_CAL_FP)(const UINT HeadNo, const UINT Command);
extern AUTO_CAL_FP auto_cal;
typedef UINT (__stdcall *GET_AUTO_CAL_FP)(const UINT HeadNo);
extern GET_AUTO_CAL_FP get_auto_cal;
typedef UINT (__stdcall *WRITE_HI_POS_FP)(const UINT HeadNo, const LONG X1, const LONG X2, const LONG Y1, const LONG Y2);
extern WRITE_HI_POS_FP write_hi_pos;
typedef void (__stdcall *SET_TIMELAG_COMPENSATION_FP)(const UINT HeadNo, const UINT TimeLagXY, const UINT TimeLagZ);
extern SET_TIMELAG_COMPENSATION_FP set_timelag_compensation;
typedef void (__stdcall *SET_SCANNER_DELAYS_CTRL_FP)(const UINT Jump, const UINT Mark, const UINT Polygon);
extern SET_SCANNER_DELAYS_CTRL_FP set_scanner_delays_ctrl;
typedef void (__stdcall *SET_SKY_WRITING_FP)(const double Timelag, const LONG LaserOnShift);
extern SET_SKY_WRITING_FP set_sky_writing;
typedef void (__stdcall *GET_HI_DATA_FP)(LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
extern GET_HI_DATA_FP get_hi_data;
typedef void (__stdcall *N_SEND_USER_DATA_FP)(const UINT CardNo, const UINT Head, const UINT Axis, const LONG Data0, const LONG Data1, const LONG Data2, const LONG Data3, const LONG Data4);
extern N_SEND_USER_DATA_FP n_send_user_data;
typedef LONG (__stdcall *N_READ_USER_DATA_FP)(const UINT CardNo, const UINT Head, const UINT Axis, LONG* Data0, LONG* Data1, LONG* Data2, LONG* Data3, LONG* Data4);
extern N_READ_USER_DATA_FP n_read_user_data;
typedef void (__stdcall *N_CONTROL_COMMAND_FP)(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Data);
extern N_CONTROL_COMMAND_FP n_control_command;
typedef LONG (__stdcall *N_GET_VALUE_FP)(const UINT CardNo, const UINT Signal);
extern N_GET_VALUE_FP n_get_value;
typedef void (__stdcall *N_GET_VALUES_FP)(const UINT CardNo, const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
extern N_GET_VALUES_FP n_get_values;
typedef void (__stdcall *N_GET_GALVO_CONTROLS_FP)(const UINT CardNo, const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
extern N_GET_GALVO_CONTROLS_FP n_get_galvo_controls;
typedef UINT (__stdcall *N_GET_HEAD_STATUS_FP)(const UINT CardNo, const UINT Head);
extern N_GET_HEAD_STATUS_FP n_get_head_status;
typedef LONG (__stdcall *N_SET_JUMP_MODE_FP)(const UINT CardNo, const LONG Flag, const UINT Length, const LONG VA1, const LONG VA2, const LONG VB1, const LONG VB2, const LONG JA1, const LONG JA2, const LONG JB1, const LONG JB2);
extern N_SET_JUMP_MODE_FP n_set_jump_mode;
typedef LONG (__stdcall *N_LOAD_JUMP_TABLE_OFFSET_FP)(const UINT CardNo, const char* Name, const UINT No, const UINT PosAck, const LONG Offset, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
extern N_LOAD_JUMP_TABLE_OFFSET_FP n_load_jump_table_offset;
typedef UINT (__stdcall *N_GET_JUMP_TABLE_FP)(const UINT CardNo, const ULONG_PTR Ptr);
extern N_GET_JUMP_TABLE_FP n_get_jump_table;
typedef UINT (__stdcall *N_SET_JUMP_TABLE_FP)(const UINT CardNo, const ULONG_PTR Ptr);
extern N_SET_JUMP_TABLE_FP n_set_jump_table;
typedef LONG (__stdcall *N_LOAD_JUMP_TABLE_FP)(const UINT CardNo, const char* Name, const UINT No, const UINT PosAck, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
extern N_LOAD_JUMP_TABLE_FP n_load_jump_table;
typedef void (__stdcall *SEND_USER_DATA_FP)(const UINT Head, const UINT Axis, const LONG Data0, const LONG Data1, const LONG Data2, const LONG Data3, const LONG Data4);
extern SEND_USER_DATA_FP send_user_data;
typedef LONG (__stdcall *READ_USER_DATA_FP)(const UINT Head, const UINT Axis, LONG* Data0, LONG* Data1, LONG* Data2, LONG* Data3, LONG* Data4);
extern READ_USER_DATA_FP read_user_data;
typedef void (__stdcall *CONTROL_COMMAND_FP)(const UINT Head, const UINT Axis, const UINT Data);
extern CONTROL_COMMAND_FP control_command;
typedef LONG (__stdcall *GET_VALUE_FP)(const UINT Signal);
extern GET_VALUE_FP get_value;
typedef void (__stdcall *GET_VALUES_FP)(const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
extern GET_VALUES_FP get_values;
typedef void (__stdcall *GET_GALVO_CONTROLS_FP)(const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
extern GET_GALVO_CONTROLS_FP get_galvo_controls;
typedef UINT (__stdcall *GET_HEAD_STATUS_FP)(const UINT Head);
extern GET_HEAD_STATUS_FP get_head_status;
typedef LONG (__stdcall *SET_JUMP_MODE_FP)(const LONG Flag, const UINT Length, const LONG VA1, const LONG VA2, const LONG VB1, const LONG VB2, const LONG JA1, const LONG JA2, const LONG JB1, const LONG JB2);
extern SET_JUMP_MODE_FP set_jump_mode;
typedef LONG (__stdcall *LOAD_JUMP_TABLE_OFFSET_FP)(const char* Name, const UINT No, const UINT PosAck, const LONG Offset, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
extern LOAD_JUMP_TABLE_OFFSET_FP load_jump_table_offset;
typedef UINT (__stdcall *GET_JUMP_TABLE_FP)(const ULONG_PTR Ptr);
extern GET_JUMP_TABLE_FP get_jump_table;
typedef UINT (__stdcall *SET_JUMP_TABLE_FP)(const ULONG_PTR Ptr);
extern SET_JUMP_TABLE_FP set_jump_table;
typedef LONG (__stdcall *LOAD_JUMP_TABLE_FP)(const char* Name, const UINT No, const UINT PosAck, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
extern LOAD_JUMP_TABLE_FP load_jump_table;
typedef UINT (__stdcall *N_GET_SCANAHEAD_PARAMS_FP)(const UINT CardNo, const UINT HeadNo, UINT* PreViewTime, UINT* Vmax, double* Amax);
extern N_GET_SCANAHEAD_PARAMS_FP n_get_scanahead_params;
typedef LONG (__stdcall *N_ACTIVATE_SCANAHEAD_AUTODELAYS_FP)(const UINT CardNo, const LONG Mode);
extern N_ACTIVATE_SCANAHEAD_AUTODELAYS_FP n_activate_scanahead_autodelays;
typedef void (__stdcall *N_SET_SCANAHEAD_LASER_SHIFTS_FP)(const UINT CardNo, const LONG dLasOn, const LONG dLasOff);
extern N_SET_SCANAHEAD_LASER_SHIFTS_FP n_set_scanahead_laser_shifts;
typedef void (__stdcall *N_SET_SCANAHEAD_LINE_PARAMS_FP)(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale);
extern N_SET_SCANAHEAD_LINE_PARAMS_FP n_set_scanahead_line_params;
typedef void (__stdcall *N_SET_SCANAHEAD_LINE_PARAMS_EX_FP)(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
extern N_SET_SCANAHEAD_LINE_PARAMS_EX_FP n_set_scanahead_line_params_ex;
typedef UINT (__stdcall *N_SET_SCANAHEAD_PARAMS_FP)(const UINT CardNo, const UINT Mode, const UINT HeadNo, const UINT TableNo, const UINT PreViewTime, const UINT Vmax, const double Amax);
extern N_SET_SCANAHEAD_PARAMS_FP n_set_scanahead_params;
typedef void (__stdcall *N_SET_SCANAHEAD_SPEED_CONTROL_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_SCANAHEAD_SPEED_CONTROL_FP n_set_scanahead_speed_control;
typedef UINT (__stdcall *GET_SCANAHEAD_PARAMS_FP)(const UINT HeadNo, UINT* PreViewTime, UINT* Vmax, double* Amax);
extern GET_SCANAHEAD_PARAMS_FP get_scanahead_params;
typedef LONG (__stdcall *ACTIVATE_SCANAHEAD_AUTODELAYS_FP)(const LONG Mode);
extern ACTIVATE_SCANAHEAD_AUTODELAYS_FP activate_scanahead_autodelays;
typedef void (__stdcall *SET_SCANAHEAD_LASER_SHIFTS_FP)(const LONG dLasOn, const LONG dLasOff);
extern SET_SCANAHEAD_LASER_SHIFTS_FP set_scanahead_laser_shifts;
typedef void (__stdcall *SET_SCANAHEAD_LINE_PARAMS_FP)(const UINT CornerScale, const UINT EndScale, const UINT AccScale);
extern SET_SCANAHEAD_LINE_PARAMS_FP set_scanahead_line_params;
typedef void (__stdcall *SET_SCANAHEAD_LINE_PARAMS_EX_FP)(const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
extern SET_SCANAHEAD_LINE_PARAMS_EX_FP set_scanahead_line_params_ex;
typedef UINT (__stdcall *SET_SCANAHEAD_PARAMS_FP)(const UINT Mode, const UINT HeadNo, const UINT TableNo, const UINT PreViewTime, const UINT Vmax, const double Amax);
extern SET_SCANAHEAD_PARAMS_FP set_scanahead_params;
typedef void (__stdcall *SET_SCANAHEAD_SPEED_CONTROL_FP)(const UINT Mode);
extern SET_SCANAHEAD_SPEED_CONTROL_FP set_scanahead_speed_control;
typedef void (__stdcall *N_STEPPER_INIT_FP)(const UINT CardNo, const UINT No, const UINT Period, const LONG Dir, const LONG Pos, const UINT Tol, const UINT Enable, const UINT WaitTime);
extern N_STEPPER_INIT_FP n_stepper_init;
typedef void (__stdcall *N_STEPPER_ENABLE_FP)(const UINT CardNo, const LONG Enable1, const LONG Enable2);
extern N_STEPPER_ENABLE_FP n_stepper_enable;
typedef void (__stdcall *N_STEPPER_DISABLE_SWITCH_FP)(const UINT CardNo, const LONG Disable1, const LONG Disable2);
extern N_STEPPER_DISABLE_SWITCH_FP n_stepper_disable_switch;
typedef void (__stdcall *N_STEPPER_CONTROL_FP)(const UINT CardNo, const LONG Period1, const LONG Period2);
extern N_STEPPER_CONTROL_FP n_stepper_control;
typedef void (__stdcall *N_STEPPER_ABS_NO_FP)(const UINT CardNo, const UINT No, const LONG Pos, const UINT WaitTime);
extern N_STEPPER_ABS_NO_FP n_stepper_abs_no;
typedef void (__stdcall *N_STEPPER_REL_NO_FP)(const UINT CardNo, const UINT No, const LONG dPos, const UINT WaitTime);
extern N_STEPPER_REL_NO_FP n_stepper_rel_no;
typedef void (__stdcall *N_STEPPER_ABS_FP)(const UINT CardNo, const LONG Pos1, const LONG Pos2, const UINT WaitTime);
extern N_STEPPER_ABS_FP n_stepper_abs;
typedef void (__stdcall *N_STEPPER_REL_FP)(const UINT CardNo, const LONG dPos1, const LONG dPos2, const UINT WaitTime);
extern N_STEPPER_REL_FP n_stepper_rel;
typedef void (__stdcall *N_GET_STEPPER_STATUS_FP)(const UINT CardNo, UINT* Status1, LONG* Pos1, UINT* Status2, LONG* Pos2);
extern N_GET_STEPPER_STATUS_FP n_get_stepper_status;
typedef void (__stdcall *STEPPER_INIT_FP)(const UINT No, const UINT Period, const LONG Dir, const LONG Pos, const UINT Tol, const UINT Enable, const UINT WaitTime);
extern STEPPER_INIT_FP stepper_init;
typedef void (__stdcall *STEPPER_ENABLE_FP)(const LONG Enable1, const LONG Enable2);
extern STEPPER_ENABLE_FP stepper_enable;
typedef void (__stdcall *STEPPER_DISABLE_SWITCH_FP)(const LONG Disable1, const LONG Disable2);
extern STEPPER_DISABLE_SWITCH_FP stepper_disable_switch;
typedef void (__stdcall *STEPPER_CONTROL_FP)(const LONG Period1, const LONG Period2);
extern STEPPER_CONTROL_FP stepper_control;
typedef void (__stdcall *STEPPER_ABS_NO_FP)(const UINT No, const LONG Pos, const UINT WaitTime);
extern STEPPER_ABS_NO_FP stepper_abs_no;
typedef void (__stdcall *STEPPER_REL_NO_FP)(const UINT No, const LONG dPos, const UINT WaitTime);
extern STEPPER_REL_NO_FP stepper_rel_no;
typedef void (__stdcall *STEPPER_ABS_FP)(const LONG Pos1, const LONG Pos2, const UINT WaitTime);
extern STEPPER_ABS_FP stepper_abs;
typedef void (__stdcall *STEPPER_REL_FP)(const LONG dPos1, const LONG dPos2, const UINT WaitTime);
extern STEPPER_REL_FP stepper_rel;
typedef void (__stdcall *GET_STEPPER_STATUS_FP)(UINT* Status1, LONG* Pos1, UINT* Status2, LONG* Pos2);
extern GET_STEPPER_STATUS_FP get_stepper_status;
typedef void (__stdcall *N_SELECT_COR_TABLE_LIST_FP)(const UINT CardNo, const UINT HeadA, const UINT HeadB);
extern N_SELECT_COR_TABLE_LIST_FP n_select_cor_table_list;
typedef void (__stdcall *SELECT_COR_TABLE_LIST_FP)(const UINT HeadA, const UINT HeadB);
extern SELECT_COR_TABLE_LIST_FP select_cor_table_list;
typedef void (__stdcall *N_LIST_NOP_FP)(const UINT CardNo);
extern N_LIST_NOP_FP n_list_nop;
typedef void (__stdcall *N_LIST_CONTINUE_FP)(const UINT CardNo);
extern N_LIST_CONTINUE_FP n_list_continue;
typedef void (__stdcall *N_LIST_NEXT_FP)(const UINT CardNo);
extern N_LIST_NEXT_FP n_list_next;
typedef void (__stdcall *N_LONG_DELAY_FP)(const UINT CardNo, const UINT Delay);
extern N_LONG_DELAY_FP n_long_delay;
typedef void (__stdcall *N_SET_END_OF_LIST_FP)(const UINT CardNo);
extern N_SET_END_OF_LIST_FP n_set_end_of_list;
typedef void (__stdcall *N_SET_WAIT_FP)(const UINT CardNo, const UINT WaitWord);
extern N_SET_WAIT_FP n_set_wait;
typedef void (__stdcall *N_LIST_JUMP_POS_FP)(const UINT CardNo, const UINT Pos);
extern N_LIST_JUMP_POS_FP n_list_jump_pos;
typedef void (__stdcall *N_LIST_JUMP_REL_FP)(const UINT CardNo, const LONG Pos);
extern N_LIST_JUMP_REL_FP n_list_jump_rel;
typedef void (__stdcall *N_LIST_REPEAT_FP)(const UINT CardNo);
extern N_LIST_REPEAT_FP n_list_repeat;
typedef void (__stdcall *N_LIST_UNTIL_FP)(const UINT CardNo, const UINT Number);
extern N_LIST_UNTIL_FP n_list_until;
typedef void (__stdcall *N_RANGE_CHECKING_FP)(const UINT CardNo, const UINT HeadNo, const UINT Mode, const UINT Data);
extern N_RANGE_CHECKING_FP n_range_checking;
typedef void (__stdcall *N_STORE_TIMESTAMP_COUNTER_LIST_FP)(const UINT CardNo);
extern N_STORE_TIMESTAMP_COUNTER_LIST_FP n_store_timestamp_counter_list;
typedef void (__stdcall *N_WAIT_FOR_TIMESTAMP_COUNTER_FP)(const UINT CardNo, const UINT TimeStampCounter);
extern N_WAIT_FOR_TIMESTAMP_COUNTER_FP n_wait_for_timestamp_counter;
typedef void (__stdcall *N_WAIT_FOR_TIMESTAMP_COUNTER_MODE_FP)(const UINT CardNo, const UINT TimeStampCounter, const UINT Mode);
extern N_WAIT_FOR_TIMESTAMP_COUNTER_MODE_FP n_wait_for_timestamp_counter_mode;
typedef void (__stdcall *N_SET_SHORT_CMD_MODE_LIST_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_SHORT_CMD_MODE_LIST_FP n_set_short_cmd_mode_list;
typedef void (__stdcall *N_SET_LIST_JUMP_FP)(const UINT CardNo, const UINT Pos);
extern N_SET_LIST_JUMP_FP n_set_list_jump;
typedef void (__stdcall *N_WAIT_FOR_TIMESTAMP_COUNTER_LONG_FP)(const UINT CardNo, const UINT WaitCounterL, const UINT WaitCounterH, const UINT MaxWaitTime, const UINT Mode);
extern N_WAIT_FOR_TIMESTAMP_COUNTER_LONG_FP n_wait_for_timestamp_counter_long;
typedef void (__stdcall *LIST_NOP_FP)(void);
extern LIST_NOP_FP list_nop;
typedef void (__stdcall *LIST_CONTINUE_FP)(void);
extern LIST_CONTINUE_FP list_continue;
typedef void (__stdcall *LIST_NEXT_FP)(void);
extern LIST_NEXT_FP list_next;
typedef void (__stdcall *LONG_DELAY_FP)(const UINT Delay);
extern LONG_DELAY_FP long_delay;
typedef void (__stdcall *SET_END_OF_LIST_FP)(void);
extern SET_END_OF_LIST_FP set_end_of_list;
typedef void (__stdcall *SET_WAIT_FP)(const UINT WaitWord);
extern SET_WAIT_FP set_wait;
typedef void (__stdcall *LIST_JUMP_POS_FP)(const UINT Pos);
extern LIST_JUMP_POS_FP list_jump_pos;
typedef void (__stdcall *LIST_JUMP_REL_FP)(const LONG Pos);
extern LIST_JUMP_REL_FP list_jump_rel;
typedef void (__stdcall *LIST_REPEAT_FP)(void);
extern LIST_REPEAT_FP list_repeat;
typedef void (__stdcall *LIST_UNTIL_FP)(const UINT Number);
extern LIST_UNTIL_FP list_until;
typedef void (__stdcall *RANGE_CHECKING_FP)(const UINT HeadNo, const UINT Mode, const UINT Data);
extern RANGE_CHECKING_FP range_checking;
typedef void (__stdcall *STORE_TIMESTAMP_COUNTER_LIST_FP)(void);
extern STORE_TIMESTAMP_COUNTER_LIST_FP store_timestamp_counter_list;
typedef void (__stdcall *WAIT_FOR_TIMESTAMP_COUNTER_FP)(const UINT TimeStampCounter);
extern WAIT_FOR_TIMESTAMP_COUNTER_FP wait_for_timestamp_counter;
typedef void (__stdcall *WAIT_FOR_TIMESTAMP_COUNTER_MODE_FP)(const UINT TimeStampCounter, const UINT Mode);
extern WAIT_FOR_TIMESTAMP_COUNTER_MODE_FP wait_for_timestamp_counter_mode;
typedef void (__stdcall *WAIT_FOR_TIMESTAMP_COUNTER_LONG_FP)(const UINT WaitCounterL, const UINT WaitCounterH, const UINT MaxWaitTime, const UINT Mode);
extern WAIT_FOR_TIMESTAMP_COUNTER_LONG_FP wait_for_timestamp_counter_long;
typedef void (__stdcall *SET_SHORT_CMD_MODE_LIST_FP)(const UINT Mode);
extern SET_SHORT_CMD_MODE_LIST_FP set_short_cmd_mode_list;
typedef void (__stdcall *SET_LIST_JUMP_FP)(const UINT Pos);
extern SET_LIST_JUMP_FP set_list_jump;
typedef void (__stdcall *N_SET_EXTSTARTPOS_LIST_FP)(const UINT CardNo, const UINT Pos);
extern N_SET_EXTSTARTPOS_LIST_FP n_set_extstartpos_list;
typedef void (__stdcall *N_SET_CONTROL_MODE_LIST_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_CONTROL_MODE_LIST_FP n_set_control_mode_list;
typedef void (__stdcall *N_SIMULATE_EXT_START_FP)(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
extern N_SIMULATE_EXT_START_FP n_simulate_ext_start;
typedef void (__stdcall *SET_EXTSTARTPOS_LIST_FP)(const UINT Pos);
extern SET_EXTSTARTPOS_LIST_FP set_extstartpos_list;
typedef void (__stdcall *SET_CONTROL_MODE_LIST_FP)(const UINT Mode);
extern SET_CONTROL_MODE_LIST_FP set_control_mode_list;
typedef void (__stdcall *SIMULATE_EXT_START_FP)(const LONG Delay, const UINT EncoderNo);
extern SIMULATE_EXT_START_FP simulate_ext_start;
typedef void (__stdcall *N_LIST_RETURN_FP)(const UINT CardNo);
extern N_LIST_RETURN_FP n_list_return;
typedef void (__stdcall *N_LIST_CALL_REPEAT_FP)(const UINT CardNo, const UINT Pos, const UINT Number);
extern N_LIST_CALL_REPEAT_FP n_list_call_repeat;
typedef void (__stdcall *N_LIST_CALL_ABS_REPEAT_FP)(const UINT CardNo, const UINT Pos, const UINT Number);
extern N_LIST_CALL_ABS_REPEAT_FP n_list_call_abs_repeat;
typedef void (__stdcall *N_LIST_CALL_FP)(const UINT CardNo, const UINT Pos);
extern N_LIST_CALL_FP n_list_call;
typedef void (__stdcall *N_LIST_CALL_ABS_FP)(const UINT CardNo, const UINT Pos);
extern N_LIST_CALL_ABS_FP n_list_call_abs;
typedef void (__stdcall *N_SUB_CALL_REPEAT_FP)(const UINT CardNo, const UINT Index, const UINT Number);
extern N_SUB_CALL_REPEAT_FP n_sub_call_repeat;
typedef void (__stdcall *N_SUB_CALL_ABS_REPEAT_FP)(const UINT CardNo, const UINT Index, const UINT Number);
extern N_SUB_CALL_ABS_REPEAT_FP n_sub_call_abs_repeat;
typedef void (__stdcall *N_SUB_CALL_FP)(const UINT CardNo, const UINT Index);
extern N_SUB_CALL_FP n_sub_call;
typedef void (__stdcall *N_SUB_CALL_ABS_FP)(const UINT CardNo, const UINT Index);
extern N_SUB_CALL_ABS_FP n_sub_call_abs;
typedef void (__stdcall *LIST_RETURN_FP)(void);
extern LIST_RETURN_FP list_return;
typedef void (__stdcall *LIST_CALL_REPEAT_FP)(const UINT Pos, const UINT Number);
extern LIST_CALL_REPEAT_FP list_call_repeat;
typedef void (__stdcall *LIST_CALL_ABS_REPEAT_FP)(const UINT Pos, const UINT Number);
extern LIST_CALL_ABS_REPEAT_FP list_call_abs_repeat;
typedef void (__stdcall *LIST_CALL_FP)(const UINT Pos);
extern LIST_CALL_FP list_call;
typedef void (__stdcall *LIST_CALL_ABS_FP)(const UINT Pos);
extern LIST_CALL_ABS_FP list_call_abs;
typedef void (__stdcall *SUB_CALL_REPEAT_FP)(const UINT Index, const UINT Number);
extern SUB_CALL_REPEAT_FP sub_call_repeat;
typedef void (__stdcall *SUB_CALL_ABS_REPEAT_FP)(const UINT Index, const UINT Number);
extern SUB_CALL_ABS_REPEAT_FP sub_call_abs_repeat;
typedef void (__stdcall *SUB_CALL_FP)(const UINT Index);
extern SUB_CALL_FP sub_call;
typedef void (__stdcall *SUB_CALL_ABS_FP)(const UINT Index);
extern SUB_CALL_ABS_FP sub_call_abs;
typedef void (__stdcall *N_LIST_CALL_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
extern N_LIST_CALL_COND_FP n_list_call_cond;
typedef void (__stdcall *N_LIST_CALL_ABS_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
extern N_LIST_CALL_ABS_COND_FP n_list_call_abs_cond;
typedef void (__stdcall *N_SUB_CALL_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
extern N_SUB_CALL_COND_FP n_sub_call_cond;
typedef void (__stdcall *N_SUB_CALL_ABS_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
extern N_SUB_CALL_ABS_COND_FP n_sub_call_abs_cond;
typedef void (__stdcall *N_LIST_JUMP_POS_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Index);
extern N_LIST_JUMP_POS_COND_FP n_list_jump_pos_cond;
typedef void (__stdcall *N_LIST_JUMP_REL_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const LONG Index);
extern N_LIST_JUMP_REL_COND_FP n_list_jump_rel_cond;
typedef void (__stdcall *N_IF_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_IF_COND_FP n_if_cond;
typedef void (__stdcall *N_IF_NOT_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_IF_NOT_COND_FP n_if_not_cond;
typedef void (__stdcall *N_IF_PIN_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_IF_PIN_COND_FP n_if_pin_cond;
typedef void (__stdcall *N_IF_NOT_PIN_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0);
extern N_IF_NOT_PIN_COND_FP n_if_not_pin_cond;
typedef void (__stdcall *N_SWITCH_IOPORT_FP)(const UINT CardNo, const UINT MaskBits, const UINT ShiftBits);
extern N_SWITCH_IOPORT_FP n_switch_ioport;
typedef void (__stdcall *N_LIST_JUMP_COND_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
extern N_LIST_JUMP_COND_FP n_list_jump_cond;
typedef void (__stdcall *LIST_CALL_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Pos);
extern LIST_CALL_COND_FP list_call_cond;
typedef void (__stdcall *LIST_CALL_ABS_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Pos);
extern LIST_CALL_ABS_COND_FP list_call_abs_cond;
typedef void (__stdcall *SUB_CALL_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Index);
extern SUB_CALL_COND_FP sub_call_cond;
typedef void (__stdcall *SUB_CALL_ABS_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Index);
extern SUB_CALL_ABS_COND_FP sub_call_abs_cond;
typedef void (__stdcall *LIST_JUMP_POS_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Pos);
extern LIST_JUMP_POS_COND_FP list_jump_pos_cond;
typedef void (__stdcall *LIST_JUMP_REL_COND_FP)(const UINT Mask1, const UINT Mask0, const LONG Pos);
extern LIST_JUMP_REL_COND_FP list_jump_rel_cond;
typedef void (__stdcall *IF_COND_FP)(const UINT Mask1, const UINT Mask0);
extern IF_COND_FP if_cond;
typedef void (__stdcall *IF_NOT_COND_FP)(const UINT Mask1, const UINT Mask0);
extern IF_NOT_COND_FP if_not_cond;
typedef void (__stdcall *IF_PIN_COND_FP)(const UINT Mask1, const UINT Mask0);
extern IF_PIN_COND_FP if_pin_cond;
typedef void (__stdcall *IF_NOT_PIN_COND_FP)(const UINT Mask1, const UINT Mask0);
extern IF_NOT_PIN_COND_FP if_not_pin_cond;
typedef void (__stdcall *SWITCH_IOPORT_FP)(const UINT MaskBits, const UINT ShiftBits);
extern SWITCH_IOPORT_FP switch_ioport;
typedef void (__stdcall *LIST_JUMP_COND_FP)(const UINT Mask1, const UINT Mask0, const UINT Pos);
extern LIST_JUMP_COND_FP list_jump_cond;
typedef void (__stdcall *N_SELECT_CHAR_SET_FP)(const UINT CardNo, const UINT No);
extern N_SELECT_CHAR_SET_FP n_select_char_set;
typedef void (__stdcall *N_MARK_TEXT_FP)(const UINT CardNo, const char* Text);
extern N_MARK_TEXT_FP n_mark_text;
typedef void (__stdcall *N_MARK_TEXT_ABS_FP)(const UINT CardNo, const char* Text);
extern N_MARK_TEXT_ABS_FP n_mark_text_abs;
typedef void (__stdcall *N_MARK_CHAR_FP)(const UINT CardNo, const UINT Char);
extern N_MARK_CHAR_FP n_mark_char;
typedef void (__stdcall *N_MARK_CHAR_ABS_FP)(const UINT CardNo, const UINT Char);
extern N_MARK_CHAR_ABS_FP n_mark_char_abs;
typedef void (__stdcall *SELECT_CHAR_SET_FP)(const UINT No);
extern SELECT_CHAR_SET_FP select_char_set;
typedef void (__stdcall *MARK_TEXT_FP)(const char* Text);
extern MARK_TEXT_FP mark_text;
typedef void (__stdcall *MARK_TEXT_ABS_FP)(const char* Text);
extern MARK_TEXT_ABS_FP mark_text_abs;
typedef void (__stdcall *MARK_CHAR_FP)(const UINT Char);
extern MARK_CHAR_FP mark_char;
typedef void (__stdcall *MARK_CHAR_ABS_FP)(const UINT Char);
extern MARK_CHAR_ABS_FP mark_char_abs;
typedef void (__stdcall *N_MARK_SERIAL_FP)(const UINT CardNo, const UINT Mode, const UINT Digits);
extern N_MARK_SERIAL_FP n_mark_serial;
typedef void (__stdcall *N_MARK_SERIAL_ABS_FP)(const UINT CardNo, const UINT Mode, const UINT Digits);
extern N_MARK_SERIAL_ABS_FP n_mark_serial_abs;
typedef void (__stdcall *N_MARK_DATE_FP)(const UINT CardNo, const UINT Part, const UINT Mode);
extern N_MARK_DATE_FP n_mark_date;
typedef void (__stdcall *N_MARK_DATE_ABS_FP)(const UINT CardNo, const UINT Part, const UINT Mode);
extern N_MARK_DATE_ABS_FP n_mark_date_abs;
typedef void (__stdcall *N_MARK_TIME_FP)(const UINT CardNo, const UINT Part, const UINT Mode);
extern N_MARK_TIME_FP n_mark_time;
typedef void (__stdcall *N_MARK_TIME_ABS_FP)(const UINT CardNo, const UINT Part, const UINT Mode);
extern N_MARK_TIME_ABS_FP n_mark_time_abs;
typedef void (__stdcall *N_SELECT_SERIAL_SET_LIST_FP)(const UINT CardNo, const UINT No);
extern N_SELECT_SERIAL_SET_LIST_FP n_select_serial_set_list;
typedef void (__stdcall *N_SET_SERIAL_STEP_LIST_FP)(const UINT CardNo, const UINT No, const UINT Step);
extern N_SET_SERIAL_STEP_LIST_FP n_set_serial_step_list;
typedef void (__stdcall *N_TIME_FIX_F_OFF_FP)(const UINT CardNo, const UINT FirstDay, const UINT Offset);
extern N_TIME_FIX_F_OFF_FP n_time_fix_f_off;
typedef void (__stdcall *N_TIME_FIX_F_FP)(const UINT CardNo, const UINT FirstDay);
extern N_TIME_FIX_F_FP n_time_fix_f;
typedef void (__stdcall *N_TIME_FIX_FP)(const UINT CardNo);
extern N_TIME_FIX_FP n_time_fix;
typedef void (__stdcall *MARK_SERIAL_FP)(const UINT Mode, const UINT Digits);
extern MARK_SERIAL_FP mark_serial;
typedef void (__stdcall *MARK_SERIAL_ABS_FP)(const UINT Mode, const UINT Digits);
extern MARK_SERIAL_ABS_FP mark_serial_abs;
typedef void (__stdcall *MARK_DATE_FP)(const UINT Part, const UINT Mode);
extern MARK_DATE_FP mark_date;
typedef void (__stdcall *MARK_DATE_ABS_FP)(const UINT Part, const UINT Mode);
extern MARK_DATE_ABS_FP mark_date_abs;
typedef void (__stdcall *MARK_TIME_FP)(const UINT Part, const UINT Mode);
extern MARK_TIME_FP mark_time;
typedef void (__stdcall *MARK_TIME_ABS_FP)(const UINT Part, const UINT Mode);
extern MARK_TIME_ABS_FP mark_time_abs;
typedef void (__stdcall *TIME_FIX_F_OFF_FP)(const UINT FirstDay, const UINT Offset);
extern TIME_FIX_F_OFF_FP time_fix_f_off;
typedef void (__stdcall *SELECT_SERIAL_SET_LIST_FP)(const UINT No);
extern SELECT_SERIAL_SET_LIST_FP select_serial_set_list;
typedef void (__stdcall *SET_SERIAL_STEP_LIST_FP)(const UINT No, const UINT Step);
extern SET_SERIAL_STEP_LIST_FP set_serial_step_list;
typedef void (__stdcall *TIME_FIX_F_FP)(const UINT FirstDay);
extern TIME_FIX_F_FP time_fix_f;
typedef void (__stdcall *TIME_FIX_FP)(void);
extern TIME_FIX_FP time_fix;
typedef void (__stdcall *N_CLEAR_IO_COND_LIST_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT MaskClear);
extern N_CLEAR_IO_COND_LIST_FP n_clear_io_cond_list;
typedef void (__stdcall *N_SET_IO_COND_LIST_FP)(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT MaskSet);
extern N_SET_IO_COND_LIST_FP n_set_io_cond_list;
typedef void (__stdcall *N_WRITE_IO_PORT_MASK_LIST_FP)(const UINT CardNo, const UINT Value, const UINT Mask);
extern N_WRITE_IO_PORT_MASK_LIST_FP n_write_io_port_mask_list;
typedef void (__stdcall *N_WRITE_IO_PORT_MASK_EX_LIST_FP)(const UINT CardNo, const UINT Value, const UINT Mask, const UINT NoDelay);
extern N_WRITE_IO_PORT_MASK_EX_LIST_FP n_write_io_port_mask_ex_list;
typedef void (__stdcall *N_WRITE_8BIT_PORT_LIST_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_8BIT_PORT_LIST_FP n_write_8bit_port_list;
typedef void (__stdcall *N_READ_IO_PORT_LIST_FP)(const UINT CardNo);
extern N_READ_IO_PORT_LIST_FP n_read_io_port_list;
typedef void (__stdcall *N_WRITE_DA_X_LIST_FP)(const UINT CardNo, const UINT x, const UINT Value);
extern N_WRITE_DA_X_LIST_FP n_write_da_x_list;
typedef void (__stdcall *N_WRITE_IO_PORT_LIST_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_IO_PORT_LIST_FP n_write_io_port_list;
typedef void (__stdcall *N_WRITE_DA_1_LIST_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_DA_1_LIST_FP n_write_da_1_list;
typedef void (__stdcall *N_WRITE_DA_2_LIST_FP)(const UINT CardNo, const UINT Value);
extern N_WRITE_DA_2_LIST_FP n_write_da_2_list;
typedef void (__stdcall *N_WRITE_PORT_LIST_FP)(const UINT CardNo, const UINT Port, const UINT Value, const UINT NoDelay);
extern N_WRITE_PORT_LIST_FP n_write_port_list;
typedef void (__stdcall *CLEAR_IO_COND_LIST_FP)(const UINT Mask1, const UINT Mask0, const UINT MaskClear);
extern CLEAR_IO_COND_LIST_FP clear_io_cond_list;
typedef void (__stdcall *SET_IO_COND_LIST_FP)(const UINT Mask1, const UINT Mask0, const UINT MaskSet);
extern SET_IO_COND_LIST_FP set_io_cond_list;
typedef void (__stdcall *WRITE_IO_PORT_MASK_LIST_FP)(const UINT Value, const UINT Mask);
extern WRITE_IO_PORT_MASK_LIST_FP write_io_port_mask_list;
typedef void (__stdcall *WRITE_IO_PORT_MASK_EX_LIST_FP)(const UINT Value, const UINT Mask, const UINT NoDelay);
extern WRITE_IO_PORT_MASK_EX_LIST_FP write_io_port_mask_ex_list;
typedef void (__stdcall *WRITE_8BIT_PORT_LIST_FP)(const UINT Value);
extern WRITE_8BIT_PORT_LIST_FP write_8bit_port_list;
typedef void (__stdcall *READ_IO_PORT_LIST_FP)(void);
extern READ_IO_PORT_LIST_FP read_io_port_list;
typedef void (__stdcall *WRITE_DA_X_LIST_FP)(const UINT x, const UINT Value);
extern WRITE_DA_X_LIST_FP write_da_x_list;
typedef void (__stdcall *WRITE_IO_PORT_LIST_FP)(const UINT Value);
extern WRITE_IO_PORT_LIST_FP write_io_port_list;
typedef void (__stdcall *WRITE_DA_1_LIST_FP)(const UINT Value);
extern WRITE_DA_1_LIST_FP write_da_1_list;
typedef void (__stdcall *WRITE_DA_2_LIST_FP)(const UINT Value);
extern WRITE_DA_2_LIST_FP write_da_2_list;
typedef void (__stdcall *WRITE_PORT_LIST_FP)(const UINT Port, const UINT Value, const UINT NoDelay);
extern WRITE_PORT_LIST_FP write_port_list;
typedef void (__stdcall *N_LASER_SIGNAL_ON_LIST_FP)(const UINT CardNo);
extern N_LASER_SIGNAL_ON_LIST_FP n_laser_signal_on_list;
typedef void (__stdcall *N_LASER_SIGNAL_OFF_LIST_FP)(const UINT CardNo);
extern N_LASER_SIGNAL_OFF_LIST_FP n_laser_signal_off_list;
typedef void (__stdcall *N_PARA_LASER_ON_PULSES_LIST_FP)(const UINT CardNo, const UINT Period, const UINT Pulses, const UINT P);
extern N_PARA_LASER_ON_PULSES_LIST_FP n_para_laser_on_pulses_list;
typedef void (__stdcall *N_LASER_ON_PULSES_LIST_FP)(const UINT CardNo, const UINT Period, const UINT Pulses);
extern N_LASER_ON_PULSES_LIST_FP n_laser_on_pulses_list;
typedef void (__stdcall *N_LASER_ON_LIST_FP)(const UINT CardNo, const UINT Period);
extern N_LASER_ON_LIST_FP n_laser_on_list;
typedef void (__stdcall *N_SET_LASER_DELAYS_FP)(const UINT CardNo, const LONG LaserOnDelay, const UINT LaserOffDelay);
extern N_SET_LASER_DELAYS_FP n_set_laser_delays;
typedef void (__stdcall *N_SET_STANDBY_LIST_FP)(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
extern N_SET_STANDBY_LIST_FP n_set_standby_list;
typedef void (__stdcall *N_SET_LASER_PULSES_FP)(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
extern N_SET_LASER_PULSES_FP n_set_laser_pulses;
typedef void (__stdcall *N_SET_FIRSTPULSE_KILLER_LIST_FP)(const UINT CardNo, const UINT Length);
extern N_SET_FIRSTPULSE_KILLER_LIST_FP n_set_firstpulse_killer_list;
typedef void (__stdcall *N_SET_QSWITCH_DELAY_LIST_FP)(const UINT CardNo, const UINT Delay);
extern N_SET_QSWITCH_DELAY_LIST_FP n_set_qswitch_delay_list;
typedef void (__stdcall *N_SET_LASER_PIN_OUT_LIST_FP)(const UINT CardNo, const UINT Pins);
extern N_SET_LASER_PIN_OUT_LIST_FP n_set_laser_pin_out_list;
typedef void (__stdcall *N_SET_VECTOR_CONTROL_FP)(const UINT CardNo, const UINT Ctrl, const UINT Value);
extern N_SET_VECTOR_CONTROL_FP n_set_vector_control;
typedef void (__stdcall *N_SET_DEFAULT_PIXEL_LIST_FP)(const UINT CardNo, const UINT PulseLength);
extern N_SET_DEFAULT_PIXEL_LIST_FP n_set_default_pixel_list;
typedef void (__stdcall *N_SET_AUTO_LASER_PARAMS_LIST_FP)(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern N_SET_AUTO_LASER_PARAMS_LIST_FP n_set_auto_laser_params_list;
typedef void (__stdcall *N_SET_PULSE_PICKING_LIST_FP)(const UINT CardNo, const UINT No);
extern N_SET_PULSE_PICKING_LIST_FP n_set_pulse_picking_list;
typedef void (__stdcall *N_SET_SOFTSTART_LEVEL_LIST_FP)(const UINT CardNo, const UINT Index, const UINT Level1, const UINT Level2, const UINT Level3);
extern N_SET_SOFTSTART_LEVEL_LIST_FP n_set_softstart_level_list;
typedef void (__stdcall *N_SET_SOFTSTART_MODE_LIST_FP)(const UINT CardNo, const UINT Mode, const UINT Number, const UINT Delay);
extern N_SET_SOFTSTART_MODE_LIST_FP n_set_softstart_mode_list;
typedef void (__stdcall *N_CONFIG_LASER_SIGNALS_LIST_FP)(const UINT CardNo, const UINT Config);
extern N_CONFIG_LASER_SIGNALS_LIST_FP n_config_laser_signals_list;
typedef void (__stdcall *N_SET_LASER_POWER_FP)(const UINT CardNo, const UINT Port, const UINT Value);
extern N_SET_LASER_POWER_FP n_set_laser_power;
typedef void (__stdcall *N_SET_PORT_DEFAULT_LIST_FP)(const UINT CardNo, const UINT Port, const UINT Value);
extern N_SET_PORT_DEFAULT_LIST_FP n_set_port_default_list;
typedef void (__stdcall *N_SPOT_DISTANCE_FP)(const UINT CardNo, const double Dist);
extern N_SPOT_DISTANCE_FP n_spot_distance;
typedef void (__stdcall *N_SET_LASER_TIMING_FP)(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength1, const UINT PulseLength2, const UINT TimeBase);
extern N_SET_LASER_TIMING_FP n_set_laser_timing;
typedef void (__stdcall *LASER_SIGNAL_ON_LIST_FP)(void);
extern LASER_SIGNAL_ON_LIST_FP laser_signal_on_list;
typedef void (__stdcall *LASER_SIGNAL_OFF_LIST_FP)(void);
extern LASER_SIGNAL_OFF_LIST_FP laser_signal_off_list;
typedef void (__stdcall *PARA_LASER_ON_PULSES_LIST_FP)(const UINT Period, const UINT Pulses, const UINT P);
extern PARA_LASER_ON_PULSES_LIST_FP para_laser_on_pulses_list;
typedef void (__stdcall *LASER_ON_PULSES_LIST_FP)(const UINT Period, const UINT Pulses);
extern LASER_ON_PULSES_LIST_FP laser_on_pulses_list;
typedef void (__stdcall *LASER_ON_LIST_FP)(const UINT Period);
extern LASER_ON_LIST_FP laser_on_list;
typedef void (__stdcall *SET_LASER_DELAYS_FP)(const LONG LaserOnDelay, const UINT LaserOffDelay);
extern SET_LASER_DELAYS_FP set_laser_delays;
typedef void (__stdcall *SET_STANDBY_LIST_FP)(const UINT HalfPeriod, const UINT PulseLength);
extern SET_STANDBY_LIST_FP set_standby_list;
typedef void (__stdcall *SET_LASER_PULSES_FP)(const UINT HalfPeriod, const UINT PulseLength);
extern SET_LASER_PULSES_FP set_laser_pulses;
typedef void (__stdcall *SET_FIRSTPULSE_KILLER_LIST_FP)(const UINT Length);
extern SET_FIRSTPULSE_KILLER_LIST_FP set_firstpulse_killer_list;
typedef void (__stdcall *SET_QSWITCH_DELAY_LIST_FP)(const UINT Delay);
extern SET_QSWITCH_DELAY_LIST_FP set_qswitch_delay_list;
typedef void (__stdcall *SET_LASER_PIN_OUT_LIST_FP)(const UINT Pins);
extern SET_LASER_PIN_OUT_LIST_FP set_laser_pin_out_list;
typedef void (__stdcall *SET_VECTOR_CONTROL_FP)(const UINT Ctrl, const UINT Value);
extern SET_VECTOR_CONTROL_FP set_vector_control;
typedef void (__stdcall *SET_DEFAULT_PIXEL_LIST_FP)(const UINT PulseLength);
extern SET_DEFAULT_PIXEL_LIST_FP set_default_pixel_list;
typedef void (__stdcall *SET_AUTO_LASER_PARAMS_LIST_FP)(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern SET_AUTO_LASER_PARAMS_LIST_FP set_auto_laser_params_list;
typedef void (__stdcall *SET_PULSE_PICKING_LIST_FP)(const UINT No);
extern SET_PULSE_PICKING_LIST_FP set_pulse_picking_list;
typedef void (__stdcall *SET_SOFTSTART_LEVEL_LIST_FP)(const UINT Index, const UINT Level1, const UINT Level2, const UINT Level3);
extern SET_SOFTSTART_LEVEL_LIST_FP set_softstart_level_list;
typedef void (__stdcall *SET_SOFTSTART_MODE_LIST_FP)(const UINT Mode, const UINT Number, const UINT Delay);
extern SET_SOFTSTART_MODE_LIST_FP set_softstart_mode_list;
typedef void (__stdcall *CONFIG_LASER_SIGNALS_LIST_FP)(const UINT Config);
extern CONFIG_LASER_SIGNALS_LIST_FP config_laser_signals_list;
typedef void (__stdcall *SET_LASER_POWER_FP)(const UINT Port, const UINT Value);
extern SET_LASER_POWER_FP set_laser_power;
typedef void (__stdcall *SET_PORT_DEFAULT_LIST_FP)(const UINT Port, const UINT Value);
extern SET_PORT_DEFAULT_LIST_FP set_port_default_list;
typedef void (__stdcall *SPOT_DISTANCE_FP)(const double Dist);
extern SPOT_DISTANCE_FP spot_distance;
typedef void (__stdcall *SET_LASER_TIMING_FP)(const UINT HalfPeriod, const UINT PulseLength1, const UINT PulseLength2, const UINT TimeBase);
extern SET_LASER_TIMING_FP set_laser_timing;
typedef void (__stdcall *N_FLY_RETURN_Z_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
extern N_FLY_RETURN_Z_FP n_fly_return_z;
typedef void (__stdcall *N_FLY_RETURN_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_FLY_RETURN_FP n_fly_return;
typedef void (__stdcall *N_SET_ROT_CENTER_LIST_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_SET_ROT_CENTER_LIST_FP n_set_rot_center_list;
typedef void (__stdcall *N_SET_EXT_START_DELAY_LIST_FP)(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
extern N_SET_EXT_START_DELAY_LIST_FP n_set_ext_start_delay_list;
typedef void (__stdcall *N_SET_FLY_X_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_FLY_X_FP n_set_fly_x;
typedef void (__stdcall *N_SET_FLY_Y_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_FLY_Y_FP n_set_fly_y;
typedef void (__stdcall *N_SET_FLY_Z_FP)(const UINT CardNo, const double ScaleZ, const UINT EndoderNo);
extern N_SET_FLY_Z_FP n_set_fly_z;
typedef void (__stdcall *N_SET_FLY_ROT_FP)(const UINT CardNo, const double Resolution);
extern N_SET_FLY_ROT_FP n_set_fly_rot;
typedef void (__stdcall *N_SET_FLY_2D_FP)(const UINT CardNo, const double ScaleX, const double ScaleY);
extern N_SET_FLY_2D_FP n_set_fly_2d;
typedef void (__stdcall *N_SET_FLY_X_POS_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_FLY_X_POS_FP n_set_fly_x_pos;
typedef void (__stdcall *N_SET_FLY_Y_POS_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_FLY_Y_POS_FP n_set_fly_y_pos;
typedef void (__stdcall *N_SET_FLY_ROT_POS_FP)(const UINT CardNo, const double Resolution);
extern N_SET_FLY_ROT_POS_FP n_set_fly_rot_pos;
typedef void (__stdcall *N_SET_FLY_LIMITS_FP)(const UINT CardNo, const LONG Xmin, const LONG Xmax, const LONG Ymin, const LONG Ymax);
extern N_SET_FLY_LIMITS_FP n_set_fly_limits;
typedef void (__stdcall *N_SET_FLY_LIMITS_Z_FP)(const UINT CardNo, const LONG Zmin, const LONG Zmax);
extern N_SET_FLY_LIMITS_Z_FP n_set_fly_limits_z;
typedef void (__stdcall *N_IF_FLY_X_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_FLY_X_OVERFLOW_FP n_if_fly_x_overflow;
typedef void (__stdcall *N_IF_FLY_Y_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_FLY_Y_OVERFLOW_FP n_if_fly_y_overflow;
typedef void (__stdcall *N_IF_FLY_Z_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_FLY_Z_OVERFLOW_FP n_if_fly_z_overflow;
typedef void (__stdcall *N_IF_NOT_FLY_X_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_NOT_FLY_X_OVERFLOW_FP n_if_not_fly_x_overflow;
typedef void (__stdcall *N_IF_NOT_FLY_Y_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_NOT_FLY_Y_OVERFLOW_FP n_if_not_fly_y_overflow;
typedef void (__stdcall *N_IF_NOT_FLY_Z_OVERFLOW_FP)(const UINT CardNo, const LONG Mode);
extern N_IF_NOT_FLY_Z_OVERFLOW_FP n_if_not_fly_z_overflow;
typedef void (__stdcall *N_CLEAR_FLY_OVERFLOW_FP)(const UINT CardNo, const UINT Mode);
extern N_CLEAR_FLY_OVERFLOW_FP n_clear_fly_overflow;
typedef void (__stdcall *N_SET_MCBSP_X_LIST_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_MCBSP_X_LIST_FP n_set_mcbsp_x_list;
typedef void (__stdcall *N_SET_MCBSP_Y_LIST_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_MCBSP_Y_LIST_FP n_set_mcbsp_y_list;
typedef void (__stdcall *N_SET_MCBSP_ROT_LIST_FP)(const UINT CardNo, const double Resolution);
extern N_SET_MCBSP_ROT_LIST_FP n_set_mcbsp_rot_list;
typedef void (__stdcall *N_SET_MCBSP_MATRIX_LIST_FP)(const UINT CardNo);
extern N_SET_MCBSP_MATRIX_LIST_FP n_set_mcbsp_matrix_list;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_X_LIST_FP)(const UINT CardNo, const double ScaleX);
extern N_SET_MCBSP_GLOBAL_X_LIST_FP n_set_mcbsp_global_x_list;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_Y_LIST_FP)(const UINT CardNo, const double ScaleY);
extern N_SET_MCBSP_GLOBAL_Y_LIST_FP n_set_mcbsp_global_y_list;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_ROT_LIST_FP)(const UINT CardNo, const double Resolution);
extern N_SET_MCBSP_GLOBAL_ROT_LIST_FP n_set_mcbsp_global_rot_list;
typedef void (__stdcall *N_SET_MCBSP_GLOBAL_MATRIX_LIST_FP)(const UINT CardNo);
extern N_SET_MCBSP_GLOBAL_MATRIX_LIST_FP n_set_mcbsp_global_matrix_list;
typedef void (__stdcall *N_SET_MCBSP_IN_LIST_FP)(const UINT CardNo, const UINT Mode, const double Scale);
extern N_SET_MCBSP_IN_LIST_FP n_set_mcbsp_in_list;
typedef void (__stdcall *N_SET_MULTI_MCBSP_IN_LIST_FP)(const UINT CardNo, const UINT Ctrl, const UINT P, const UINT Mode);
extern N_SET_MULTI_MCBSP_IN_LIST_FP n_set_multi_mcbsp_in_list;
typedef void (__stdcall *N_WAIT_FOR_ENCODER_MODE_FP)(const UINT CardNo, const LONG Value, const UINT EncoderNo, const LONG Mode);
extern N_WAIT_FOR_ENCODER_MODE_FP n_wait_for_encoder_mode;
typedef void (__stdcall *N_WAIT_FOR_MCBSP_FP)(const UINT CardNo, const UINT Axis, const LONG Value, const LONG Mode);
extern N_WAIT_FOR_MCBSP_FP n_wait_for_mcbsp;
typedef void (__stdcall *N_SET_ENCODER_SPEED_FP)(const UINT CardNo, const UINT EncoderNo, const double Speed, const double Smooth);
extern N_SET_ENCODER_SPEED_FP n_set_encoder_speed;
typedef void (__stdcall *N_GET_MCBSP_LIST_FP)(const UINT CardNo);
extern N_GET_MCBSP_LIST_FP n_get_mcbsp_list;
typedef void (__stdcall *N_STORE_ENCODER_FP)(const UINT CardNo, const UINT Pos);
extern N_STORE_ENCODER_FP n_store_encoder;
typedef void (__stdcall *N_WAIT_FOR_ENCODER_IN_RANGE_MODE_FP)(const UINT CardNo, const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax, const UINT Mode);
extern N_WAIT_FOR_ENCODER_IN_RANGE_MODE_FP n_wait_for_encoder_in_range_mode;
typedef void (__stdcall *N_WAIT_FOR_ENCODER_IN_RANGE_FP)(const UINT CardNo, const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax);
extern N_WAIT_FOR_ENCODER_IN_RANGE_FP n_wait_for_encoder_in_range;
typedef void (__stdcall *N_ACTIVATE_FLY_XY_FP)(const UINT CardNo, const double ScaleX, const double ScaleY);
extern N_ACTIVATE_FLY_XY_FP n_activate_fly_xy;
typedef void (__stdcall *N_ACTIVATE_FLY_2D_FP)(const UINT CardNo, const double ScaleX, const double ScaleY);
extern N_ACTIVATE_FLY_2D_FP n_activate_fly_2d;
typedef void (__stdcall *N_ACTIVATE_FLY_XY_ENCODER_FP)(const UINT CardNo, const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
extern N_ACTIVATE_FLY_XY_ENCODER_FP n_activate_fly_xy_encoder;
typedef void (__stdcall *N_ACTIVATE_FLY_2D_ENCODER_FP)(const UINT CardNo, const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
extern N_ACTIVATE_FLY_2D_ENCODER_FP n_activate_fly_2d_encoder;
typedef void (__stdcall *N_IF_NOT_ACTIVATED_FP)(const UINT CardNo);
extern N_IF_NOT_ACTIVATED_FP n_if_not_activated;
typedef void (__stdcall *N_PARK_POSITION_FP)(const UINT CardNo, const UINT Mode, const LONG X, const LONG Y);
extern N_PARK_POSITION_FP n_park_position;
typedef void (__stdcall *N_PARK_RETURN_FP)(const UINT CardNo, const UINT Mode, const LONG X, const LONG Y);
extern N_PARK_RETURN_FP n_park_return;
typedef void (__stdcall *N_FLY_PREDICTION_FP)(const UINT CardNo, UINT PredictionX, UINT PredictionY);
extern N_FLY_PREDICTION_FP n_fly_prediction;
typedef void (__stdcall *N_SET_FLY_1_AXIS_FP)(const UINT CardNo, const UINT Axis, const UINT Mode, const double Scale);
extern N_SET_FLY_1_AXIS_FP n_set_fly_1_axis;
typedef void (__stdcall *N_FLY_RETURN_1_AXIS_FP)(const UINT CardNo, const UINT Axis, const LONG RetPos);
extern N_FLY_RETURN_1_AXIS_FP n_fly_return_1_axis;
typedef void (__stdcall *N_WAIT_FOR_1_AXIS_FP)(const UINT CardNo, LONG Value, const UINT EncoderMode, const LONG WaitMode, const UINT LaserMode);
extern N_WAIT_FOR_1_AXIS_FP n_wait_for_1_axis;
typedef void (__stdcall *N_ACTIVATE_FLY_1_AXIS_FP)(const UINT CardNo, const UINT Axis, const UINT Mode, const double Scale, const LONG Offset);
extern N_ACTIVATE_FLY_1_AXIS_FP n_activate_fly_1_axis;
typedef void (__stdcall *N_PARK_POSITION_1_AXIS_FP)(const UINT CardNo, const UINT Mode, const UINT Axis, const LONG ParkPos);
extern N_PARK_POSITION_1_AXIS_FP n_park_position_1_axis;
typedef void (__stdcall *N_PARK_RETURN_1_AXIS_FP)(const UINT CardNo, const UINT Mode, const UINT Axis, const LONG RetPos);
extern N_PARK_RETURN_1_AXIS_FP n_park_return_1_axis;
typedef void (__stdcall *N_SET_FLY_2_AXES_FP)(const UINT CardNo, const UINT Axis1, const UINT Mode1, const double Scale1, const UINT Axis2, const UINT Mode2, const double Scale2);
extern N_SET_FLY_2_AXES_FP n_set_fly_2_axes;
typedef void (__stdcall *N_FLY_RETURN_2_AXES_FP)(const UINT CardNo, const UINT Axis1, const LONG RetPos1, const UINT Axis2, const LONG RetPos2);
extern N_FLY_RETURN_2_AXES_FP n_fly_return_2_axes;
typedef void (__stdcall *N_WAIT_FOR_2_AXES_FP)(const UINT CardNo, const UINT EncoderModeX, const LONG MinValueX, const LONG MaxValueX, const UINT EncoderModeY, const LONG MinValueY, const LONG MaxValueY, const LONG WaitMode, const UINT LaserMode);
extern N_WAIT_FOR_2_AXES_FP n_wait_for_2_axes;
typedef void (__stdcall *N_ACTIVATE_FLY_2_AXES_FP)(const UINT CardNo, const UINT ModeX, const double ScaleX, const LONG OffsetX, const UINT ModeY, const double ScaleY, const LONG OffsetY);
extern N_ACTIVATE_FLY_2_AXES_FP n_activate_fly_2_axes;
typedef void (__stdcall *N_PARK_POSITION_2_AXES_FP)(const UINT CardNo, const UINT Mode, const LONG ParkPosX, const LONG ParkPosY);
extern N_PARK_POSITION_2_AXES_FP n_park_position_2_axes;
typedef void (__stdcall *N_PARK_RETURN_2_AXES_FP)(const UINT CardNo, const UINT Mode, const LONG RetPosX, const LONG RetkPosY);
extern N_PARK_RETURN_2_AXES_FP n_park_return_2_axes;
typedef void (__stdcall *N_SET_FLY_3_AXES_FP)(const UINT CardNo, const UINT ModeX, const double ScaleX, const UINT ModeY, const double ScaleY, const UINT ModeZ, const double ScaleZ);
extern N_SET_FLY_3_AXES_FP n_set_fly_3_axes;
typedef void (__stdcall *N_FLY_RETURN_3_AXES_FP)(const UINT CardNo, const LONG RetPosX, const LONG RetPosY, const LONG RetPosZ);
extern N_FLY_RETURN_3_AXES_FP n_fly_return_3_axes;
typedef void (__stdcall *N_INIT_FLY_2D_LIST_FP)(const UINT CardNo, const LONG OffsetX, const LONG OffsetY, const UINT No);
extern N_INIT_FLY_2D_LIST_FP n_init_fly_2d_list;
typedef void (__stdcall *N_FLY_DISABLE_LIST_FP)(const UINT CardNo);
extern N_FLY_DISABLE_LIST_FP n_fly_disable_list;
typedef void (__stdcall *N_WAIT_FOR_ENCODER_FP)(const UINT CardNo, const LONG Value, const UINT EncoderNo);
extern N_WAIT_FOR_ENCODER_FP n_wait_for_encoder;
typedef void (__stdcall *FLY_RETURN_Z_FP)(const LONG X, const LONG Y, const LONG Z);
extern FLY_RETURN_Z_FP fly_return_z;
typedef void (__stdcall *FLY_RETURN_FP)(const LONG X, const LONG Y);
extern FLY_RETURN_FP fly_return;
typedef void (__stdcall *SET_ROT_CENTER_LIST_FP)(const LONG X, const LONG Y);
extern SET_ROT_CENTER_LIST_FP set_rot_center_list;
typedef void (__stdcall *SET_EXT_START_DELAY_LIST_FP)(const LONG Delay, const UINT EncoderNo);
extern SET_EXT_START_DELAY_LIST_FP set_ext_start_delay_list;
typedef void (__stdcall *SET_FLY_X_FP)(const double ScaleX);
extern SET_FLY_X_FP set_fly_x;
typedef void (__stdcall *SET_FLY_Y_FP)(const double ScaleY);
extern SET_FLY_Y_FP set_fly_y;
typedef void (__stdcall *SET_FLY_Z_FP)(const double ScaleZ, const UINT EncoderNo);
extern SET_FLY_Z_FP set_fly_z;
typedef void (__stdcall *SET_FLY_ROT_FP)(const double Resolution);
extern SET_FLY_ROT_FP set_fly_rot;
typedef void (__stdcall *SET_FLY_2D_FP)(const double ScaleX, const double ScaleY);
extern SET_FLY_2D_FP set_fly_2d;
typedef void (__stdcall *SET_FLY_X_POS_FP)(const double ScaleX);
extern SET_FLY_X_POS_FP set_fly_x_pos;
typedef void (__stdcall *SET_FLY_Y_POS_FP)(const double ScaleY);
extern SET_FLY_Y_POS_FP set_fly_y_pos;
typedef void (__stdcall *SET_FLY_ROT_POS_FP)(const double Resolution);
extern SET_FLY_ROT_POS_FP set_fly_rot_pos;
typedef void (__stdcall *SET_FLY_LIMITS_FP)(const LONG Xmin, const LONG Xmax, const LONG Ymin, const LONG Ymax);
extern SET_FLY_LIMITS_FP set_fly_limits;
typedef void (__stdcall *SET_FLY_LIMITS_Z_FP)(const LONG Zmin, const LONG Zmax);
extern SET_FLY_LIMITS_Z_FP set_fly_limits_z;
typedef void (__stdcall *IF_FLY_X_OVERFLOW_FP)(const LONG Mode);
extern IF_FLY_X_OVERFLOW_FP if_fly_x_overflow;
typedef void (__stdcall *IF_FLY_Y_OVERFLOW_FP)(const LONG Mode);
extern IF_FLY_Y_OVERFLOW_FP if_fly_y_overflow;
typedef void (__stdcall *IF_FLY_Z_OVERFLOW_FP)(const LONG Mode);
extern IF_FLY_Z_OVERFLOW_FP if_fly_z_overflow;
typedef void (__stdcall *IF_NOT_FLY_X_OVERFLOW_FP)(const LONG Mode);
extern IF_NOT_FLY_X_OVERFLOW_FP if_not_fly_x_overflow;
typedef void (__stdcall *IF_NOT_FLY_Y_OVERFLOW_FP)(const LONG Mode);
extern IF_NOT_FLY_Y_OVERFLOW_FP if_not_fly_y_overflow;
typedef void (__stdcall *IF_NOT_FLY_Z_OVERFLOW_FP)(const LONG Mode);
extern IF_NOT_FLY_Z_OVERFLOW_FP if_not_fly_z_overflow;
typedef void (__stdcall *CLEAR_FLY_OVERFLOW_FP)(const UINT Mode);
extern CLEAR_FLY_OVERFLOW_FP clear_fly_overflow;
typedef void (__stdcall *SET_MCBSP_X_LIST_FP)(const double ScaleX);
extern SET_MCBSP_X_LIST_FP set_mcbsp_x_list;
typedef void (__stdcall *SET_MCBSP_Y_LIST_FP)(const double ScaleY);
extern SET_MCBSP_Y_LIST_FP set_mcbsp_y_list;
typedef void (__stdcall *SET_MCBSP_ROT_LIST_FP)(const double Resolution);
extern SET_MCBSP_ROT_LIST_FP set_mcbsp_rot_list;
typedef void (__stdcall *SET_MCBSP_MATRIX_LIST_FP)(void);
extern SET_MCBSP_MATRIX_LIST_FP set_mcbsp_matrix_list;
typedef void (__stdcall *SET_MCBSP_GLOBAL_X_LIST_FP)(const double ScaleX);
extern SET_MCBSP_GLOBAL_X_LIST_FP set_mcbsp_global_x_list;
typedef void (__stdcall *SET_MCBSP_GLOBAL_Y_LIST_FP)(const double ScaleY);
extern SET_MCBSP_GLOBAL_Y_LIST_FP set_mcbsp_global_y_list;
typedef void (__stdcall *SET_MCBSP_GLOBAL_ROT_LIST_FP)(const double Resolution);
extern SET_MCBSP_GLOBAL_ROT_LIST_FP set_mcbsp_global_rot_list;
typedef void (__stdcall *SET_MCBSP_GLOBAL_MATRIX_LIST_FP)(void);
extern SET_MCBSP_GLOBAL_MATRIX_LIST_FP set_mcbsp_global_matrix_list;
typedef void (__stdcall *SET_MCBSP_IN_LIST_FP)(const UINT Mode, const double Scale);
extern SET_MCBSP_IN_LIST_FP set_mcbsp_in_list;
typedef void (__stdcall *SET_MULTI_MCBSP_IN_LIST_FP)(const UINT Ctrl, const UINT P, const UINT Mode);
extern SET_MULTI_MCBSP_IN_LIST_FP set_multi_mcbsp_in_list;
typedef void (__stdcall *WAIT_FOR_ENCODER_MODE_FP)(const LONG Value, const UINT EncoderNo, const LONG Mode);
extern WAIT_FOR_ENCODER_MODE_FP wait_for_encoder_mode;
typedef void (__stdcall *WAIT_FOR_MCBSP_FP)(const UINT Axis, const LONG Value, const LONG Mode);
extern WAIT_FOR_MCBSP_FP wait_for_mcbsp;
typedef void (__stdcall *SET_ENCODER_SPEED_FP)(const UINT EncoderNo, const double Speed, const double Smooth);
extern SET_ENCODER_SPEED_FP set_encoder_speed;
typedef void (__stdcall *GET_MCBSP_LIST_FP)(void);
extern GET_MCBSP_LIST_FP get_mcbsp_list;
typedef void (__stdcall *STORE_ENCODER_FP)(const UINT Pos);
extern STORE_ENCODER_FP store_encoder;
typedef void (__stdcall *WAIT_FOR_ENCODER_IN_RANGE_MODE_FP)(const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax, const UINT Mode);
extern WAIT_FOR_ENCODER_IN_RANGE_MODE_FP wait_for_encoder_in_range_mode;
typedef void (__stdcall *WAIT_FOR_ENCODER_IN_RANGE_FP)(const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax);
extern WAIT_FOR_ENCODER_IN_RANGE_FP wait_for_encoder_in_range;
typedef void (__stdcall *ACTIVATE_FLY_XY_FP)(const double ScaleX, const double ScaleY);
extern ACTIVATE_FLY_XY_FP activate_fly_xy;
typedef void (__stdcall *ACTIVATE_FLY_2D_FP)(const double ScaleX, const double ScaleY);
extern ACTIVATE_FLY_2D_FP activate_fly_2d;
typedef void (__stdcall *ACTIVATE_FLY_XY_ENCODER_FP)(const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
extern ACTIVATE_FLY_XY_ENCODER_FP activate_fly_xy_encoder;
typedef void (__stdcall *ACTIVATE_FLY_2D_ENCODER_FP)(const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
extern ACTIVATE_FLY_2D_ENCODER_FP activate_fly_2d_encoder;
typedef void (__stdcall *IF_NOT_ACTIVATED_FP)(void);
extern IF_NOT_ACTIVATED_FP if_not_activated;
typedef void (__stdcall *PARK_POSITION_FP)(const UINT Mode, const LONG X, const LONG Y);
extern PARK_POSITION_FP park_position;
typedef void (__stdcall *PARK_RETURN_FP)(const UINT Mode, const LONG X, const LONG Y);
extern PARK_RETURN_FP park_return;
typedef void (__stdcall *FLY_PREDICTION_FP)(UINT PredictionX, UINT PredictionY);
extern FLY_PREDICTION_FP fly_prediction;
typedef void (__stdcall *SET_FLY_1_AXIS_FP)(const UINT Axis, const UINT Mode, const double Scale);
extern SET_FLY_1_AXIS_FP set_fly_1_axis;
typedef void (__stdcall *FLY_RETURN_1_AXIS_FP)(const UINT Axis, const LONG RetPos);
extern FLY_RETURN_1_AXIS_FP fly_return_1_axis;
typedef void (__stdcall *WAIT_FOR_1_AXIS_FP)(const LONG Value, const UINT EncoderMode, const LONG WaitMode, const UINT LaserMode);
extern WAIT_FOR_1_AXIS_FP wait_for_1_axis;
typedef void (__stdcall *ACTIVATE_FLY_1_AXIS_FP)(const UINT Axis, const UINT Mode, const double Scale, const LONG Offset);
extern ACTIVATE_FLY_1_AXIS_FP activate_fly_1_axis;
typedef void (__stdcall *PARK_POSITION_1_AXIS_FP)(const UINT Mode, const UINT Axis, const LONG ParkPos);
extern PARK_POSITION_1_AXIS_FP park_position_1_axis;
typedef void (__stdcall *PARK_RETURN_1_AXIS_FP)(const UINT Mode, const UINT Axis, const LONG RetPos);
extern PARK_RETURN_1_AXIS_FP park_return_1_axis;
typedef void (__stdcall *SET_FLY_2_AXES_FP)(const UINT Axis1, const UINT Mode1, const double Scale1, const UINT Axis2, const UINT Mode2, const double Scale2);
extern SET_FLY_2_AXES_FP set_fly_2_axes;
typedef void (__stdcall *FLY_RETURN_2_AXES_FP)(const UINT Axis1, const LONG RetPos1, const UINT Axis2, const LONG RetPos2);
extern FLY_RETURN_2_AXES_FP fly_return_2_axes;
typedef void (__stdcall *WAIT_FOR_2_AXES_FP)(const UINT EncoderModeX, const LONG MinValueX, const LONG MaxValueX, const UINT EncoderModeY, const LONG MinValueY, const LONG MaxValueY, const LONG WaitMode, const UINT LaserMode);
extern WAIT_FOR_2_AXES_FP wait_for_2_axes;
typedef void (__stdcall *ACTIVATE_FLY_2_AXES_FP)(const UINT ModeX, const double ScaleX, const LONG OffsetX, const UINT ModeY, const double ScaleY, const LONG OffsetY);
extern ACTIVATE_FLY_2_AXES_FP activate_fly_2_axes;
typedef void (__stdcall *PARK_POSITION_2_AXES_FP)(const UINT Mode, const LONG ParkPosX, const LONG ParkPosY);
extern PARK_POSITION_2_AXES_FP park_position_2_axes;
typedef void (__stdcall *PARK_RETURN_2_AXES_FP)(const UINT Mode, const LONG RetPosX, const LONG RetPosY);
extern PARK_RETURN_2_AXES_FP park_return_2_axes;
typedef void (__stdcall *SET_FLY_3_AXES_FP)(const UINT ModeX, const double ScaleX, const UINT ModeY, const double ScaleY, const UINT ModeZ, const double ScaleZ);
extern SET_FLY_3_AXES_FP set_fly_3_axes;
typedef void (__stdcall *FLY_RETURN_3_AXES_FP)(const LONG RetPosX, const LONG RetPosY, const LONG RetPosZ);
extern FLY_RETURN_3_AXES_FP fly_return_3_axes;
typedef void (__stdcall *INIT_FLY_2D_LIST_FP)(const LONG OffsetX, const LONG OffsetY, const UINT No);
extern INIT_FLY_2D_LIST_FP init_fly_2d_list;
typedef void (__stdcall *FLY_DISABLE_LIST_FP)(void);
extern FLY_DISABLE_LIST_FP fly_disable_list;
typedef void (__stdcall *WAIT_FOR_ENCODER_FP)(const LONG Value, const UINT EncoderNo);
extern WAIT_FOR_ENCODER_FP wait_for_encoder;
typedef void (__stdcall *N_SAVE_AND_RESTART_TIMER_FP)(const UINT CardNo);
extern N_SAVE_AND_RESTART_TIMER_FP n_save_and_restart_timer;
typedef void (__stdcall *N_SET_WOBBEL_MODE_PHASE_FP)(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode, const double Phase);
extern N_SET_WOBBEL_MODE_PHASE_FP n_set_wobbel_mode_phase;
typedef void (__stdcall *N_SET_WOBBEL_MODE_FP)(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode);
extern N_SET_WOBBEL_MODE_FP n_set_wobbel_mode;
typedef void (__stdcall *N_SET_WOBBEL_FP)(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq);
extern N_SET_WOBBEL_FP n_set_wobbel;
typedef void (__stdcall *N_SET_WOBBEL_DIRECTION_FP)(const UINT CardNo, const LONG dX, const LONG dY);
extern N_SET_WOBBEL_DIRECTION_FP n_set_wobbel_direction;
typedef void (__stdcall *N_SET_WOBBEL_CONTROL_FP)(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern N_SET_WOBBEL_CONTROL_FP n_set_wobbel_control;
typedef void (__stdcall *N_SET_WOBBEL_VECTOR_FP)(const UINT CardNo, const double dTrans, const double dLong, const UINT Period, const double dPower);
extern N_SET_WOBBEL_VECTOR_FP n_set_wobbel_vector;
typedef void (__stdcall *N_SET_WOBBEL_VECTOR_2_FP)(const UINT CardNo, const double dTrans, const double dLong, const UINT Period, const double dPower, const double dPower2, const UINT Ctrl);
extern N_SET_WOBBEL_VECTOR_2_FP n_set_wobbel_vector_2;
typedef void (__stdcall *N_SET_WOBBEL_OFFSET_FP)(const UINT CardNo, const LONG OffsetTrans, const LONG OffsetLong);
extern N_SET_WOBBEL_OFFSET_FP n_set_wobbel_offset;
typedef void (__stdcall *N_SET_TRIGGER_FP)(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2);
extern N_SET_TRIGGER_FP n_set_trigger;
typedef void (__stdcall *N_SET_TRIGGER4_FP)(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4);
extern N_SET_TRIGGER4_FP n_set_trigger4;
typedef void (__stdcall *N_SET_TRIGGER8_FP)(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4, const UINT Signal5, const UINT Signal6, const UINT Signal7, const UINT Signal8);
extern N_SET_TRIGGER8_FP n_set_trigger8;
typedef void (__stdcall *N_SET_PIXEL_LINE_3D_FP)(const UINT CardNo, const UINT Channel, const UINT HalfPeriod, const double dX, const double dY, const double dZ);
extern N_SET_PIXEL_LINE_3D_FP n_set_pixel_line_3d;
typedef void (__stdcall *N_SET_PIXEL_LINE_FP)(const UINT CardNo, const UINT Channel, const UINT HalfPeriod, const double dX, const double dY);
extern N_SET_PIXEL_LINE_FP n_set_pixel_line;
typedef void (__stdcall *N_SET_N_PIXEL_FP)(const UINT CardNo, const UINT PortOutValue1, const UINT PortOutValue2, const UINT Number);
extern N_SET_N_PIXEL_FP n_set_n_pixel;
typedef void (__stdcall *N_SET_PIXEL_FP)(const UINT CardNo, const UINT PortOutValue1, const UINT PortOutValue2);
extern N_SET_PIXEL_FP n_set_pixel;
typedef void (__stdcall *N_RS232_WRITE_TEXT_LIST_FP)(const UINT CardNo, const char* pData);
extern N_RS232_WRITE_TEXT_LIST_FP n_rs232_write_text_list;
typedef void (__stdcall *N_SET_MCBSP_OUT_FP)(const UINT CardNo, const UINT Signal1, const UINT Signal2);
extern N_SET_MCBSP_OUT_FP n_set_mcbsp_out;
typedef void (__stdcall *N_SET_MCBSP_OUT_OIE_LIST_FP)(const UINT CardNo, const UINT Signal1, const UINT Signal2);
extern N_SET_MCBSP_OUT_OIE_LIST_FP n_set_mcbsp_out_oie_list;
typedef void (__stdcall *N_SET_MCBSP_OUT_PTR_LIST_FP)(const UINT CardNo, const UINT Number, const ULONG_PTR SignalPtr);
extern N_SET_MCBSP_OUT_PTR_LIST_FP n_set_mcbsp_out_ptr_list;
typedef void (__stdcall *N_CAMMING_FP)(const UINT CardNo, const UINT FirstPos, const UINT NPos, const UINT No, const UINT Ctrl, const double Scale, const UINT Code);
extern N_CAMMING_FP n_camming;
typedef void (__stdcall *N_PERIODIC_TOGGLE_LIST_FP)(const UINT CardNo, const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
extern N_PERIODIC_TOGGLE_LIST_FP n_periodic_toggle_list;
typedef void (__stdcall *N_MICRO_VECTOR_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const LONG LasOn, const LONG LasOff);
extern N_MICRO_VECTOR_ABS_3D_FP n_micro_vector_abs_3d;
typedef void (__stdcall *N_MICRO_VECTOR_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const LONG LasOn, const LONG LasOff);
extern N_MICRO_VECTOR_REL_3D_FP n_micro_vector_rel_3d;
typedef void (__stdcall *N_MICRO_VECTOR_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG LasOn, const LONG LasOff);
extern N_MICRO_VECTOR_ABS_FP n_micro_vector_abs;
typedef void (__stdcall *N_MICRO_VECTOR_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG LasOn, const LONG LasOff);
extern N_MICRO_VECTOR_REL_FP n_micro_vector_rel;
typedef void (__stdcall *N_MULTI_AXIS_MICRO_VECTOR_SCANNER_LIST_FP)(const UINT CardNo, const LONG X0, const LONG Y0, const LONG X1, const LONG Y1, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
extern N_MULTI_AXIS_MICRO_VECTOR_SCANNER_LIST_FP n_multi_axis_micro_vector_scanner_list;
typedef void (__stdcall *N_MULTI_AXIS_MICRO_VECTOR_STAGE_LIST_FP)(const UINT CardNo, const LONG X, const LONG Y, const double Stage, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
extern N_MULTI_AXIS_MICRO_VECTOR_STAGE_LIST_FP n_multi_axis_micro_vector_stage_list;
typedef void (__stdcall *N_MICRO_VECTOR_SET_POSITION_FP)(const UINT CardNo, const LONG X0, const LONG X1, const LONG X2, const LONG X3, const LONG LasOn, const LONG LasOff);
extern N_MICRO_VECTOR_SET_POSITION_FP n_micro_vector_set_position;
typedef void (__stdcall *N_MULTI_AXIS_FLAGS_LIST_FP)(const UINT CardNo, const UINT Flags);
extern N_MULTI_AXIS_FLAGS_LIST_FP n_multi_axis_flags_list;
typedef void (__stdcall *N_SET_FREE_VARIABLE_LIST_FP)(const UINT CardNo, const UINT VarNo, const UINT Value);
extern N_SET_FREE_VARIABLE_LIST_FP n_set_free_variable_list;
typedef void (__stdcall *N_JUMP_ABS_DRILL_2_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern N_JUMP_ABS_DRILL_2_FP n_jump_abs_drill_2;
typedef void (__stdcall *N_JUMP_REL_DRILL_2_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern N_JUMP_REL_DRILL_2_FP n_jump_rel_drill_2;
typedef void (__stdcall *N_JUMP_ABS_DRILL_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime);
extern N_JUMP_ABS_DRILL_FP n_jump_abs_drill;
typedef void (__stdcall *N_JUMP_REL_DRILL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime);
extern N_JUMP_REL_DRILL_FP n_jump_rel_drill;
typedef void (__stdcall *N_JUMP_ABS_DRILL_3_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern N_JUMP_ABS_DRILL_3_FP n_jump_abs_drill_3;
typedef void (__stdcall *N_JUMP_REL_DRILL_3_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern N_JUMP_REL_DRILL_3_FP n_jump_rel_drill_3;
typedef void (__stdcall *SAVE_AND_RESTART_TIMER_FP)(void);
extern SAVE_AND_RESTART_TIMER_FP save_and_restart_timer;
typedef void (__stdcall *SET_WOBBEL_MODE_PHASE_FP)(const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode, const double Phase);
extern SET_WOBBEL_MODE_PHASE_FP set_wobbel_mode_phase;
typedef void (__stdcall *SET_WOBBEL_MODE_FP)(const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode);
extern SET_WOBBEL_MODE_FP set_wobbel_mode;
typedef void (__stdcall *SET_WOBBEL_FP)(const UINT Transversal, const UINT Longitudinal, const double Freq);
extern SET_WOBBEL_FP set_wobbel;
typedef void (__stdcall *SET_WOBBEL_DIRECTION_FP)(const LONG dX, const LONG dY);
extern SET_WOBBEL_DIRECTION_FP set_wobbel_direction;
typedef void (__stdcall *SET_WOBBEL_CONTROL_FP)(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
extern SET_WOBBEL_CONTROL_FP set_wobbel_control;
typedef void (__stdcall *SET_WOBBEL_VECTOR_FP)(const double dTrans, const double dLong, const UINT Period, const double dPower);
extern SET_WOBBEL_VECTOR_FP set_wobbel_vector;
typedef void (__stdcall *SET_WOBBEL_VECTOR_2_FP)(const double dTrans, const double dLong, const UINT Period, const double dPower, const double dPower2, const UINT Ctrl);
extern SET_WOBBEL_VECTOR_2_FP set_wobbel_vector_2;
typedef void (__stdcall *SET_WOBBEL_OFFSET_FP)(const LONG OffsetTrans, const LONG OffsetLong);
extern SET_WOBBEL_OFFSET_FP set_wobbel_offset;
typedef void (__stdcall *SET_TRIGGER_FP)(const UINT Period, const UINT Signal1, const UINT Signal2);
extern SET_TRIGGER_FP set_trigger;
typedef void (__stdcall *SET_TRIGGER4_FP)(const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4);
extern SET_TRIGGER4_FP set_trigger4;
typedef void (__stdcall *SET_TRIGGER8_FP)(const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4, const UINT Signal5, const UINT Signal6, const UINT Signal7, const UINT Signal8);
extern SET_TRIGGER8_FP set_trigger8;
typedef void (__stdcall *SET_PIXEL_LINE_3D_FP)(const UINT Channel, const UINT HalfPeriod, const double dX, const double dY, const double dZ);
extern SET_PIXEL_LINE_3D_FP set_pixel_line_3d;
typedef void (__stdcall *SET_PIXEL_LINE_FP)(const UINT Channel, const UINT HalfPeriod, const double dX, const double dY);
extern SET_PIXEL_LINE_FP set_pixel_line;
typedef void (__stdcall *SET_N_PIXEL_FP)(const UINT PortOutValue1, const UINT PortOutValue2, const UINT Number);
extern SET_N_PIXEL_FP set_n_pixel;
typedef void (__stdcall *SET_PIXEL_FP)(const UINT PortOutValue1, const UINT PortOutValue2);
extern SET_PIXEL_FP set_pixel;
typedef void (__stdcall *RS232_WRITE_TEXT_LIST_FP)(const char* pData);
extern RS232_WRITE_TEXT_LIST_FP rs232_write_text_list;
typedef void (__stdcall *SET_MCBSP_OUT_FP)(const UINT Signal1, const UINT Signal2);
extern SET_MCBSP_OUT_FP set_mcbsp_out;
typedef void (__stdcall *SET_MCBSP_OUT_OIE_LIST_FP)(const UINT Signal1, const UINT Signal2);
extern SET_MCBSP_OUT_OIE_LIST_FP set_mcbsp_out_oie_list;
typedef void (__stdcall *SET_MCBSP_OUT_PTR_LIST_FP)(const UINT Number, const ULONG_PTR SignalPtr);
extern SET_MCBSP_OUT_PTR_LIST_FP set_mcbsp_out_ptr_list;
typedef void (__stdcall *CAMMING_FP)(const UINT FirstPos, const UINT NPos, const UINT No, const UINT Ctrl, const double Scale, const UINT Code);
extern CAMMING_FP camming;
typedef void (__stdcall *PERIODIC_TOGGLE_LIST_FP)(const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
extern PERIODIC_TOGGLE_LIST_FP periodic_toggle_list;
typedef void (__stdcall *MICRO_VECTOR_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const LONG LasOn, const LONG LasOff);
extern MICRO_VECTOR_ABS_3D_FP micro_vector_abs_3d;
typedef void (__stdcall *MICRO_VECTOR_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const LONG LasOn, const LONG LasOff);
extern MICRO_VECTOR_REL_3D_FP micro_vector_rel_3d;
typedef void (__stdcall *MICRO_VECTOR_ABS_FP)(const LONG X, const LONG Y, const LONG LasOn, const LONG LasOff);
extern MICRO_VECTOR_ABS_FP micro_vector_abs;
typedef void (__stdcall *MICRO_VECTOR_REL_FP)(const LONG dX, const LONG dY, const LONG LasOn, const LONG LasOff);
extern MICRO_VECTOR_REL_FP micro_vector_rel;
typedef void (__stdcall *MULTI_AXIS_MICRO_VECTOR_SCANNER_LIST_FP)(const LONG X0, const LONG Y0, const LONG X1, const LONG Y1, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
extern MULTI_AXIS_MICRO_VECTOR_SCANNER_LIST_FP multi_axis_micro_vector_scanner_list;
typedef void (__stdcall *MULTI_AXIS_MICRO_VECTOR_STAGE_LIST_FP)(const LONG X, const LONG Y, const double Stage, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
extern MULTI_AXIS_MICRO_VECTOR_STAGE_LIST_FP multi_axis_micro_vector_stage_list;
typedef void (__stdcall *MICRO_VECTOR_SET_POSITION_FP)(const LONG X0, const LONG X1, const LONG X2, const LONG X3, const LONG LasOn, const LONG LasOff);
extern MICRO_VECTOR_SET_POSITION_FP micro_vector_set_position;
typedef void (__stdcall *MULTI_AXIS_FLAGS_LIST_FP)(const UINT Flags);
extern MULTI_AXIS_FLAGS_LIST_FP multi_axis_flags_list;
typedef void (__stdcall *SET_FREE_VARIABLE_LIST_FP)(const UINT VarNo, const UINT Value);
extern SET_FREE_VARIABLE_LIST_FP set_free_variable_list;
typedef void (__stdcall *JUMP_ABS_DRILL_2_FP)(const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern JUMP_ABS_DRILL_2_FP jump_abs_drill_2;
typedef void (__stdcall *JUMP_REL_DRILL_2_FP)(const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern JUMP_REL_DRILL_2_FP jump_rel_drill_2;
typedef void (__stdcall *JUMP_ABS_DRILL_FP)(const LONG X, const LONG Y, const UINT DrillTime);
extern JUMP_ABS_DRILL_FP jump_abs_drill;
typedef void (__stdcall *JUMP_REL_DRILL_FP)(const LONG dX, const LONG dY, const UINT DrillTime);
extern JUMP_REL_DRILL_FP jump_rel_drill;
typedef void (__stdcall *JUMP_ABS_DRILL_3_FP)(const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern JUMP_ABS_DRILL_3_FP jump_abs_drill_3;
typedef void (__stdcall *JUMP_REL_DRILL_3_FP)(const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
extern JUMP_REL_DRILL_3_FP jump_rel_drill_3;
typedef void (__stdcall *N_TIMED_MARK_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double T);
extern N_TIMED_MARK_ABS_3D_FP n_timed_mark_abs_3d;
typedef void (__stdcall *N_TIMED_MARK_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double T);
extern N_TIMED_MARK_REL_3D_FP n_timed_mark_rel_3d;
typedef void (__stdcall *N_TIMED_MARK_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const double T);
extern N_TIMED_MARK_ABS_FP n_timed_mark_abs;
typedef void (__stdcall *N_TIMED_MARK_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const double T);
extern N_TIMED_MARK_REL_FP n_timed_mark_rel;
typedef void (__stdcall *TIMED_MARK_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const double T);
extern TIMED_MARK_ABS_3D_FP timed_mark_abs_3d;
typedef void (__stdcall *TIMED_MARK_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const double T);
extern TIMED_MARK_REL_3D_FP timed_mark_rel_3d;
typedef void (__stdcall *TIMED_MARK_ABS_FP)(const LONG X, const LONG Y, const double T);
extern TIMED_MARK_ABS_FP timed_mark_abs;
typedef void (__stdcall *TIMED_MARK_REL_FP)(const LONG dX, const LONG dY, const double T);
extern TIMED_MARK_REL_FP timed_mark_rel;
typedef void (__stdcall *N_MARK_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
extern N_MARK_ABS_3D_FP n_mark_abs_3d;
typedef void (__stdcall *N_MARK_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ);
extern N_MARK_REL_3D_FP n_mark_rel_3d;
typedef void (__stdcall *N_MARK_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_MARK_ABS_FP n_mark_abs;
typedef void (__stdcall *N_MARK_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY);
extern N_MARK_REL_FP n_mark_rel;
typedef void (__stdcall *MARK_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z);
extern MARK_ABS_3D_FP mark_abs_3d;
typedef void (__stdcall *MARK_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ);
extern MARK_REL_3D_FP mark_rel_3d;
typedef void (__stdcall *MARK_ABS_FP)(const LONG X, const LONG Y);
extern MARK_ABS_FP mark_abs;
typedef void (__stdcall *MARK_REL_FP)(const LONG dX, const LONG dY);
extern MARK_REL_FP mark_rel;
typedef void (__stdcall *N_TIMED_JUMP_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double T);
extern N_TIMED_JUMP_ABS_3D_FP n_timed_jump_abs_3d;
typedef void (__stdcall *N_TIMED_JUMP_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double T);
extern N_TIMED_JUMP_REL_3D_FP n_timed_jump_rel_3d;
typedef void (__stdcall *N_TIMED_JUMP_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const double T);
extern N_TIMED_JUMP_ABS_FP n_timed_jump_abs;
typedef void (__stdcall *N_TIMED_JUMP_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const double T);
extern N_TIMED_JUMP_REL_FP n_timed_jump_rel;
typedef void (__stdcall *TIMED_JUMP_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const double T);
extern TIMED_JUMP_ABS_3D_FP timed_jump_abs_3d;
typedef void (__stdcall *TIMED_JUMP_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const double T);
extern TIMED_JUMP_REL_3D_FP timed_jump_rel_3d;
typedef void (__stdcall *TIMED_JUMP_ABS_FP)(const LONG X, const LONG Y, const double T);
extern TIMED_JUMP_ABS_FP timed_jump_abs;
typedef void (__stdcall *TIMED_JUMP_REL_FP)(const LONG dX, const LONG dY, const double T);
extern TIMED_JUMP_REL_FP timed_jump_rel;
typedef void (__stdcall *N_JUMP_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
extern N_JUMP_ABS_3D_FP n_jump_abs_3d;
typedef void (__stdcall *N_JUMP_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ);
extern N_JUMP_REL_3D_FP n_jump_rel_3d;
typedef void (__stdcall *N_JUMP_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y);
extern N_JUMP_ABS_FP n_jump_abs;
typedef void (__stdcall *N_JUMP_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY);
extern N_JUMP_REL_FP n_jump_rel;
typedef void (__stdcall *JUMP_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z);
extern JUMP_ABS_3D_FP jump_abs_3d;
typedef void (__stdcall *JUMP_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ);
extern JUMP_REL_3D_FP jump_rel_3d;
typedef void (__stdcall *JUMP_ABS_FP)(const LONG X, const LONG Y);
extern JUMP_ABS_FP jump_abs;
typedef void (__stdcall *JUMP_REL_FP)(const LONG dX, const LONG dY);
extern JUMP_REL_FP jump_rel;
typedef void (__stdcall *N_PARA_MARK_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P);
extern N_PARA_MARK_ABS_3D_FP n_para_mark_abs_3d;
typedef void (__stdcall *N_PARA_MARK_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P);
extern N_PARA_MARK_REL_3D_FP n_para_mark_rel_3d;
typedef void (__stdcall *N_PARA_MARK_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT P);
extern N_PARA_MARK_ABS_FP n_para_mark_abs;
typedef void (__stdcall *N_PARA_MARK_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT P);
extern N_PARA_MARK_REL_FP n_para_mark_rel;
typedef void (__stdcall *PARA_MARK_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const UINT P);
extern PARA_MARK_ABS_3D_FP para_mark_abs_3d;
typedef void (__stdcall *PARA_MARK_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const UINT P);
extern PARA_MARK_REL_3D_FP para_mark_rel_3d;
typedef void (__stdcall *PARA_MARK_ABS_FP)(const LONG X, const LONG Y, const UINT P);
extern PARA_MARK_ABS_FP para_mark_abs;
typedef void (__stdcall *PARA_MARK_REL_FP)(const LONG dX, const LONG dY, const UINT P);
extern PARA_MARK_REL_FP para_mark_rel;
typedef void (__stdcall *N_PARA_JUMP_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P);
extern N_PARA_JUMP_ABS_3D_FP n_para_jump_abs_3d;
typedef void (__stdcall *N_PARA_JUMP_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P);
extern N_PARA_JUMP_REL_3D_FP n_para_jump_rel_3d;
typedef void (__stdcall *N_PARA_JUMP_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT P);
extern N_PARA_JUMP_ABS_FP n_para_jump_abs;
typedef void (__stdcall *N_PARA_JUMP_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT P);
extern N_PARA_JUMP_REL_FP n_para_jump_rel;
typedef void (__stdcall *PARA_JUMP_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const UINT P);
extern PARA_JUMP_ABS_3D_FP para_jump_abs_3d;
typedef void (__stdcall *PARA_JUMP_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const UINT P);
extern PARA_JUMP_REL_3D_FP para_jump_rel_3d;
typedef void (__stdcall *PARA_JUMP_ABS_FP)(const LONG X, const LONG Y, const UINT P);
extern PARA_JUMP_ABS_FP para_jump_abs;
typedef void (__stdcall *PARA_JUMP_REL_FP)(const LONG dX, const LONG dY, const UINT P);
extern PARA_JUMP_REL_FP para_jump_rel;
typedef void (__stdcall *N_TIMED_PARA_MARK_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
extern N_TIMED_PARA_MARK_ABS_3D_FP n_timed_para_mark_abs_3d;
typedef void (__stdcall *N_TIMED_PARA_MARK_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
extern N_TIMED_PARA_MARK_REL_3D_FP n_timed_para_mark_rel_3d;
typedef void (__stdcall *N_TIMED_PARA_JUMP_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
extern N_TIMED_PARA_JUMP_ABS_3D_FP n_timed_para_jump_abs_3d;
typedef void (__stdcall *N_TIMED_PARA_JUMP_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
extern N_TIMED_PARA_JUMP_REL_3D_FP n_timed_para_jump_rel_3d;
typedef void (__stdcall *N_TIMED_PARA_MARK_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT P, const double T);
extern N_TIMED_PARA_MARK_ABS_FP n_timed_para_mark_abs;
typedef void (__stdcall *N_TIMED_PARA_MARK_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT P, const double T);
extern N_TIMED_PARA_MARK_REL_FP n_timed_para_mark_rel;
typedef void (__stdcall *N_TIMED_PARA_JUMP_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const UINT P, const double T);
extern N_TIMED_PARA_JUMP_ABS_FP n_timed_para_jump_abs;
typedef void (__stdcall *N_TIMED_PARA_JUMP_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const UINT P, const double T);
extern N_TIMED_PARA_JUMP_REL_FP n_timed_para_jump_rel;
typedef void (__stdcall *TIMED_PARA_MARK_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
extern TIMED_PARA_MARK_ABS_3D_FP timed_para_mark_abs_3d;
typedef void (__stdcall *TIMED_PARA_MARK_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
extern TIMED_PARA_MARK_REL_3D_FP timed_para_mark_rel_3d;
typedef void (__stdcall *TIMED_PARA_JUMP_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
extern TIMED_PARA_JUMP_ABS_3D_FP timed_para_jump_abs_3d;
typedef void (__stdcall *TIMED_PARA_JUMP_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
extern TIMED_PARA_JUMP_REL_3D_FP timed_para_jump_rel_3d;
typedef void (__stdcall *TIMED_PARA_MARK_ABS_FP)(const LONG X, const LONG Y, const UINT P, const double T);
extern TIMED_PARA_MARK_ABS_FP timed_para_mark_abs;
typedef void (__stdcall *TIMED_PARA_MARK_REL_FP)(const LONG dX, const LONG dY, const UINT P, const double T);
extern TIMED_PARA_MARK_REL_FP timed_para_mark_rel;
typedef void (__stdcall *TIMED_PARA_JUMP_ABS_FP)(const LONG X, const LONG Y, const UINT P, const double T);
extern TIMED_PARA_JUMP_ABS_FP timed_para_jump_abs;
typedef void (__stdcall *TIMED_PARA_JUMP_REL_FP)(const LONG dX, const LONG dY, const UINT P, const double T);
extern TIMED_PARA_JUMP_REL_FP timed_para_jump_rel;
typedef void (__stdcall *N_SET_DEFOCUS_LIST_FP)(const UINT CardNo, const LONG Shift);
extern N_SET_DEFOCUS_LIST_FP n_set_defocus_list;
typedef void (__stdcall *N_SET_DEFOCUS_2_LIST_FP)(const UINT CardNo, const LONG Shift, const UINT Mode);
extern N_SET_DEFOCUS_2_LIST_FP n_set_defocus_2_list;
typedef void (__stdcall *N_SET_DEFOCUS_OFFSET_LIST_FP)(const UINT CardNo, const LONG Shift);
extern N_SET_DEFOCUS_OFFSET_LIST_FP n_set_defocus_offset_list;
typedef void (__stdcall *N_SET_ZOOM_LIST_FP)(const UINT CardNo, const UINT Zoom);
extern N_SET_ZOOM_LIST_FP n_set_zoom_list;
typedef void (__stdcall *SET_DEFOCUS_LIST_FP)(const LONG Shift);
extern SET_DEFOCUS_LIST_FP set_defocus_list;
typedef void (__stdcall *SET_DEFOCUS_2_LIST_FP)(const LONG Shift, const UINT Mode);
extern SET_DEFOCUS_2_LIST_FP set_defocus_2_list;
typedef void (__stdcall *SET_DEFOCUS_OFFSET_LIST_FP)(const LONG Shift);
extern SET_DEFOCUS_OFFSET_LIST_FP set_defocus_offset_list;
typedef void (__stdcall *SET_ZOOM_LIST_FP)(const UINT Zoom);
extern SET_ZOOM_LIST_FP set_zoom_list;
typedef void (__stdcall *N_TIMED_ARC_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const double Angle, const double T);
extern N_TIMED_ARC_ABS_FP n_timed_arc_abs;
typedef void (__stdcall *N_TIMED_ARC_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const double Angle, const double T);
extern N_TIMED_ARC_REL_FP n_timed_arc_rel;
typedef void (__stdcall *TIMED_ARC_ABS_FP)(const LONG X, const LONG Y, const double Angle, const double T);
extern TIMED_ARC_ABS_FP timed_arc_abs;
typedef void (__stdcall *TIMED_ARC_REL_FP)(const LONG dX, const LONG dY, const double Angle, const double T);
extern TIMED_ARC_REL_FP timed_arc_rel;
typedef void (__stdcall *N_ARC_ABS_3D_FP)(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double Angle);
extern N_ARC_ABS_3D_FP n_arc_abs_3d;
typedef void (__stdcall *N_ARC_REL_3D_FP)(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double Angle);
extern N_ARC_REL_3D_FP n_arc_rel_3d;
typedef void (__stdcall *N_ARC_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const double Angle);
extern N_ARC_ABS_FP n_arc_abs;
typedef void (__stdcall *N_ARC_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const double Angle);
extern N_ARC_REL_FP n_arc_rel;
typedef void (__stdcall *N_SET_ELLIPSE_FP)(const UINT CardNo, const UINT A, const UINT B, const double Phi0, const double Phi);
extern N_SET_ELLIPSE_FP n_set_ellipse;
typedef void (__stdcall *N_MARK_ELLIPSE_ABS_FP)(const UINT CardNo, const LONG X, const LONG Y, const double Alpha);
extern N_MARK_ELLIPSE_ABS_FP n_mark_ellipse_abs;
typedef void (__stdcall *N_MARK_ELLIPSE_REL_FP)(const UINT CardNo, const LONG dX, const LONG dY, const double Alpha);
extern N_MARK_ELLIPSE_REL_FP n_mark_ellipse_rel;
typedef void (__stdcall *ARC_ABS_3D_FP)(const LONG X, const LONG Y, const LONG Z, const double Angle);
extern ARC_ABS_3D_FP arc_abs_3d;
typedef void (__stdcall *ARC_REL_3D_FP)(const LONG dX, const LONG dY, const LONG dZ, const double Angle);
extern ARC_REL_3D_FP arc_rel_3d;
typedef void (__stdcall *ARC_ABS_FP)(const LONG X, const LONG Y, const double Angle);
extern ARC_ABS_FP arc_abs;
typedef void (__stdcall *ARC_REL_FP)(const LONG dX, const LONG dY, const double Angle);
extern ARC_REL_FP arc_rel;
typedef void (__stdcall *SET_ELLIPSE_FP)(const UINT A, const UINT B, const double Phi0, const double Phi);
extern SET_ELLIPSE_FP set_ellipse;
typedef void (__stdcall *MARK_ELLIPSE_ABS_FP)(const LONG X, const LONG Y, const double Alpha);
extern MARK_ELLIPSE_ABS_FP mark_ellipse_abs;
typedef void (__stdcall *MARK_ELLIPSE_REL_FP)(const LONG dX, const LONG dY, const double Alpha);
extern MARK_ELLIPSE_REL_FP mark_ellipse_rel;
typedef void (__stdcall *N_SET_OFFSET_XYZ_LIST_FP)(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
extern N_SET_OFFSET_XYZ_LIST_FP n_set_offset_xyz_list;
typedef void (__stdcall *N_SET_OFFSET_LIST_FP)(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
extern N_SET_OFFSET_LIST_FP n_set_offset_list;
typedef void (__stdcall *N_SET_MATRIX_LIST_FP)(const UINT CardNo, const UINT HeadNo, const UINT Ind1, const UINT Ind2, const double Mij, const UINT at_once);
extern N_SET_MATRIX_LIST_FP n_set_matrix_list;
typedef void (__stdcall *N_SET_ANGLE_LIST_FP)(const UINT CardNo, const UINT HeadNo, const double Angle, const UINT at_once);
extern N_SET_ANGLE_LIST_FP n_set_angle_list;
typedef void (__stdcall *N_SET_SCALE_LIST_FP)(const UINT CardNo, const UINT HeadNo, const double Scale, const UINT at_once);
extern N_SET_SCALE_LIST_FP n_set_scale_list;
typedef void (__stdcall *N_APPLY_MCBSP_LIST_FP)(const UINT CardNo, const UINT HeadNo, const UINT at_once);
extern N_APPLY_MCBSP_LIST_FP n_apply_mcbsp_list;
typedef void (__stdcall *SET_OFFSET_XYZ_LIST_FP)(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
extern SET_OFFSET_XYZ_LIST_FP set_offset_xyz_list;
typedef void (__stdcall *SET_OFFSET_LIST_FP)(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
extern SET_OFFSET_LIST_FP set_offset_list;
typedef void (__stdcall *SET_MATRIX_LIST_FP)(const UINT HeadNo, const UINT Ind1, const UINT Ind2, const double Mij, const UINT at_once);
extern SET_MATRIX_LIST_FP set_matrix_list;
typedef void (__stdcall *SET_ANGLE_LIST_FP)(const UINT HeadNo, const double Angle, const UINT at_once);
extern SET_ANGLE_LIST_FP set_angle_list;
typedef void (__stdcall *SET_SCALE_LIST_FP)(const UINT HeadNo, const double Scale, const UINT at_once);
extern SET_SCALE_LIST_FP set_scale_list;
typedef void (__stdcall *APPLY_MCBSP_LIST_FP)(const UINT HeadNo, const UINT at_once);
extern APPLY_MCBSP_LIST_FP apply_mcbsp_list;
typedef void (__stdcall *N_SET_MARK_SPEED_FP)(const UINT CardNo, const double Speed);
extern N_SET_MARK_SPEED_FP n_set_mark_speed;
typedef void (__stdcall *N_SET_JUMP_SPEED_FP)(const UINT CardNo, const double Speed);
extern N_SET_JUMP_SPEED_FP n_set_jump_speed;
typedef void (__stdcall *N_SET_SKY_WRITING_PARA_LIST_FP)(const UINT CardNo, const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
extern N_SET_SKY_WRITING_PARA_LIST_FP n_set_sky_writing_para_list;
typedef void (__stdcall *N_SET_SKY_WRITING_LIST_FP)(const UINT CardNo, const double Timelag, const LONG LaserOnShift);
extern N_SET_SKY_WRITING_LIST_FP n_set_sky_writing_list;
typedef void (__stdcall *N_SET_SKY_WRITING_LIMIT_LIST_FP)(const UINT CardNo, const double CosAngle);
extern N_SET_SKY_WRITING_LIMIT_LIST_FP n_set_sky_writing_limit_list;
typedef void (__stdcall *N_SET_SKY_WRITING_MODE_LIST_FP)(const UINT CardNo, const UINT Mode);
extern N_SET_SKY_WRITING_MODE_LIST_FP n_set_sky_writing_mode_list;
typedef void (__stdcall *N_SET_SCANNER_DELAYS_FP)(const UINT CardNo, const UINT Jump, const UINT Mark, const UINT Polygon);
extern N_SET_SCANNER_DELAYS_FP n_set_scanner_delays;
typedef void (__stdcall *N_SET_JUMP_MODE_LIST_FP)(const UINT CardNo, const LONG Flag);
extern N_SET_JUMP_MODE_LIST_FP n_set_jump_mode_list;
typedef void (__stdcall *N_ENDURING_WOBBEL_FP)(const UINT CardNo);
extern N_ENDURING_WOBBEL_FP n_enduring_wobbel;
typedef void (__stdcall *N_SET_DELAY_MODE_LIST_FP)(const UINT CardNo, const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
extern N_SET_DELAY_MODE_LIST_FP n_set_delay_mode_list;
typedef void (__stdcall *N_SET_SKY_WRITING_MIN_SPEED_LIST_FP)(const UINT CardNo, const double Speed);
extern N_SET_SKY_WRITING_MIN_SPEED_LIST_FP n_set_sky_writing_min_speed_list;
typedef void (__stdcall *N_SET_SKY_WRITING_SCALE_LIST_FP)(const UINT CardNo, const double Scale);
extern N_SET_SKY_WRITING_SCALE_LIST_FP n_set_sky_writing_scale_list;
typedef void (__stdcall *SET_MARK_SPEED_FP)(const double Speed);
extern SET_MARK_SPEED_FP set_mark_speed;
typedef void (__stdcall *SET_JUMP_SPEED_FP)(const double Speed);
extern SET_JUMP_SPEED_FP set_jump_speed;
typedef void (__stdcall *SET_SKY_WRITING_PARA_LIST_FP)(const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
extern SET_SKY_WRITING_PARA_LIST_FP set_sky_writing_para_list;
typedef void (__stdcall *SET_SKY_WRITING_LIST_FP)(const double Timelag, const LONG LaserOnShift);
extern SET_SKY_WRITING_LIST_FP set_sky_writing_list;
typedef void (__stdcall *SET_SKY_WRITING_LIMIT_LIST_FP)(const double CosAngle);
extern SET_SKY_WRITING_LIMIT_LIST_FP set_sky_writing_limit_list;
typedef void (__stdcall *SET_SKY_WRITING_MODE_LIST_FP)(const UINT Mode);
extern SET_SKY_WRITING_MODE_LIST_FP set_sky_writing_mode_list;
typedef void (__stdcall *SET_SCANNER_DELAYS_FP)(const UINT Jump, const UINT Mark, const UINT Polygon);
extern SET_SCANNER_DELAYS_FP set_scanner_delays;
typedef void (__stdcall *SET_JUMP_MODE_LIST_FP)(const LONG Flag);
extern SET_JUMP_MODE_LIST_FP set_jump_mode_list;
typedef void (__stdcall *ENDURING_WOBBEL_FP)(void);
extern ENDURING_WOBBEL_FP enduring_wobbel;
typedef void (__stdcall *SET_DELAY_MODE_LIST_FP)(const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
extern SET_DELAY_MODE_LIST_FP set_delay_mode_list;
typedef void (__stdcall *SET_SKY_WRITING_MIN_SPEED_LIST_FP)(const double Speed);
extern SET_SKY_WRITING_MIN_SPEED_LIST_FP set_sky_writing_min_speed_list;
typedef void (__stdcall *SET_SKY_WRITING_SCALE_LIST_FP)(const double Scale);
extern SET_SKY_WRITING_SCALE_LIST_FP set_sky_writing_scale_list;
typedef void (__stdcall *N_ACTIVATE_SCANAHEAD_AUTODELAYS_LIST_FP)(const UINT CardNo, const LONG Mode);
extern N_ACTIVATE_SCANAHEAD_AUTODELAYS_LIST_FP n_activate_scanahead_autodelays_list;
typedef void (__stdcall *N_SET_SCANAHEAD_LASER_SHIFTS_LIST_FP)(const UINT CardNo, const LONG dLasOn, const LONG dLasOff);
extern N_SET_SCANAHEAD_LASER_SHIFTS_LIST_FP n_set_scanahead_laser_shifts_list;
typedef void (__stdcall *N_SET_SCANAHEAD_LINE_PARAMS_LIST_FP)(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale);
extern N_SET_SCANAHEAD_LINE_PARAMS_LIST_FP n_set_scanahead_line_params_list;
typedef void (__stdcall *N_SET_SCANAHEAD_LINE_PARAMS_EX_LIST_FP)(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
extern N_SET_SCANAHEAD_LINE_PARAMS_EX_LIST_FP n_set_scanahead_line_params_ex_list;
typedef void (__stdcall *ACTIVATE_SCANAHEAD_AUTODELAYS_LIST_FP)(const LONG Mode);
extern ACTIVATE_SCANAHEAD_AUTODELAYS_LIST_FP activate_scanahead_autodelays_list;
typedef void (__stdcall *SET_SCANAHEAD_LASER_SHIFTS_LIST_FP)(const LONG dLasOn, const LONG dLasOff);
extern SET_SCANAHEAD_LASER_SHIFTS_LIST_FP set_scanahead_laser_shifts_list;
typedef void (__stdcall *SET_SCANAHEAD_LINE_PARAMS_LIST_FP)(const UINT CornerScale, const UINT EndScale, const UINT AccScale);
extern SET_SCANAHEAD_LINE_PARAMS_LIST_FP set_scanahead_line_params_list;
typedef void (__stdcall *SET_SCANAHEAD_LINE_PARAMS_EX_LIST_FP)(const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
extern SET_SCANAHEAD_LINE_PARAMS_EX_LIST_FP set_scanahead_line_params_ex_list;
typedef void (__stdcall *N_STEPPER_ENABLE_LIST_FP)(const UINT CardNo, const LONG Enable1, const LONG Enable2);
extern N_STEPPER_ENABLE_LIST_FP n_stepper_enable_list;
typedef void (__stdcall *N_STEPPER_CONTROL_LIST_FP)(const UINT CardNo, const LONG Period1, const LONG Period2);
extern N_STEPPER_CONTROL_LIST_FP n_stepper_control_list;
typedef void (__stdcall *N_STEPPER_ABS_NO_LIST_FP)(const UINT CardNo, const UINT No, const LONG Pos);
extern N_STEPPER_ABS_NO_LIST_FP n_stepper_abs_no_list;
typedef void (__stdcall *N_STEPPER_REL_NO_LIST_FP)(const UINT CardNo, const UINT No, const LONG dPos);
extern N_STEPPER_REL_NO_LIST_FP n_stepper_rel_no_list;
typedef void (__stdcall *N_STEPPER_ABS_LIST_FP)(const UINT CardNo, const LONG Pos1, const LONG Pos2);
extern N_STEPPER_ABS_LIST_FP n_stepper_abs_list;
typedef void (__stdcall *N_STEPPER_REL_LIST_FP)(const UINT CardNo, const LONG dPos1, const LONG dPos2);
extern N_STEPPER_REL_LIST_FP n_stepper_rel_list;
typedef void (__stdcall *N_STEPPER_WAIT_FP)(const UINT CardNo, const UINT No);
extern N_STEPPER_WAIT_FP n_stepper_wait;
typedef void (__stdcall *STEPPER_ENABLE_LIST_FP)(const LONG Enable1, const LONG Enable2);
extern STEPPER_ENABLE_LIST_FP stepper_enable_list;
typedef void (__stdcall *STEPPER_CONTROL_LIST_FP)(const LONG Period1, const LONG Period2);
extern STEPPER_CONTROL_LIST_FP stepper_control_list;
typedef void (__stdcall *STEPPER_ABS_NO_LIST_FP)(const UINT No, const LONG Pos);
extern STEPPER_ABS_NO_LIST_FP stepper_abs_no_list;
typedef void (__stdcall *STEPPER_REL_NO_LIST_FP)(const UINT No, const LONG dPos);
extern STEPPER_REL_NO_LIST_FP stepper_rel_no_list;
typedef void (__stdcall *STEPPER_ABS_LIST_FP)(const LONG Pos1, const LONG Pos2);
extern STEPPER_ABS_LIST_FP stepper_abs_list;
typedef void (__stdcall *STEPPER_REL_LIST_FP)(const LONG dPos1, const LONG dPos2);
extern STEPPER_REL_LIST_FP stepper_rel_list;
typedef void (__stdcall *STEPPER_WAIT_FP)(const UINT No);
extern STEPPER_WAIT_FP stepper_wait;
typedef void (__stdcall *N_SET_LASER_TIMING_TABLE_FP)(const UINT CardNo, const UINT Index, const UINT F);
extern N_SET_LASER_TIMING_TABLE_FP n_set_laser_timing_table;
typedef void (__stdcall *N_SET_DUTY_CYCLE_TABLE_FP)(const UINT CardNo, const UINT Index, const UINT DutyCycle);
extern N_SET_DUTY_CYCLE_TABLE_FP n_set_duty_cycle_table;
typedef void (__stdcall *N_REGULATION3_FP)(const UINT CardNo, const UINT Fmax, const UINT Fmin);
extern N_REGULATION3_FP n_regulation3;
typedef void (__stdcall *SET_LASER_TIMING_TABLE_FP)(const UINT Index, const UINT F);
extern SET_LASER_TIMING_TABLE_FP set_laser_timing_table;
typedef void (__stdcall *SET_DUTY_CYCLE_TABLE_FP)(const UINT Index, const UINT DutyCycle);
extern SET_DUTY_CYCLE_TABLE_FP set_duty_cycle_table;
typedef void (__stdcall *REGULATION3_FP)(const UINT Fmax, const UINT Fmin);
extern REGULATION3_FP regulation3;

#if defined(__cplusplus)
}      //  extern "C"
#endif //defined(__cplusplus)